/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.java;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.MissingTypeError;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.NativeType;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.OutputLanguageUtil;
import com.google.gxp.compiler.java.IllegalJavaTypeError;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUtil
extends OutputLanguageUtil {
    private static final Set<String> FORBIDDEN_OPS = ImmutableSet.of("instanceof", "^", "~", "&", "<<", ">>", ">>>", "|", "--", "-=", "/=", "*=", "&=", "%=", "++", "+=", "<<=", "=", ">>=", ">>>=", "|=", "^=");
    private static final String NOT_IN_CAST_LOOKAHEAD = "(?!\\s*[,)>])";
    private static final Pattern OPS_FINDER = JavaUtil.compileUnionPattern("\\binstanceof\\b", Pattern.quote(">>>="), Pattern.quote("<<="), Pattern.quote(">>="), Pattern.quote(">>>") + "(?!\\s*[,)>])", Pattern.quote("--"), Pattern.quote("-="), Pattern.quote("!="), Pattern.quote("/="), Pattern.quote("^="), Pattern.quote("*="), Pattern.quote("&&"), Pattern.quote("&="), Pattern.quote("%="), Pattern.quote("++"), Pattern.quote("+="), Pattern.quote("<<"), Pattern.quote("<="), Pattern.quote("=="), Pattern.quote(">="), Pattern.quote(">>") + "(?!\\s*[,)>])", Pattern.quote("|="), Pattern.quote("||"), "\\bnew\\b", Pattern.quote("-"), Pattern.quote("!"), Pattern.quote("/"), Pattern.quote("^"), Pattern.quote("~"), Pattern.quote("*"), Pattern.quote("&"), Pattern.quote("%"), Pattern.quote("+"), Pattern.quote("<"), Pattern.quote("="), Pattern.quote(">"), Pattern.quote("|"), Pattern.quote("?"));
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");
    private static final Set<String> TYPE_ARGUMENT_QUALIFIERS = ImmutableSet.of(new String[]{"extends", "super"});
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private static final Pattern TYPE_TOKEN_REGEX = Pattern.compile("^([A-Za-z_][A-Za-z0-9_]*|[\\?\\[\\]<>{},\\.])(.*)", 32);
    private static final Map<String, String> PRIMITIVE_TO_BOXED_MAP = ImmutableMap.builder().put("boolean", "Boolean").put("byte", "Number").put("char", "Character").put("double", "Number").put("float", "Number").put("int", "Number").put("long", "Number").put("short", "Number").build();
    private static final Set<String> PRIMITIVE_TYPES = ImmutableSet.copyOf(PRIMITIVE_TO_BOXED_MAP.keySet());
    private static final Predicate<String> ISVALID_BOOLEAN = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            return (s = s.trim()).equals("true") || s.equals("false");
        }
    };
    private static final Predicate<String> ISVALID_BYTE = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Byte.valueOf(s.trim());
            return true;
        }
    };
    private static final Predicate<String> ISVALID_CHAR = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            return s.length() == 1;
        }
    };
    private static final Predicate<String> ISVALID_DOUBLE = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Double.valueOf(s.trim());
            return true;
        }
    };
    private static final Predicate<String> ISVALID_FLOAT = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Float.valueOf(s.trim());
            return true;
        }
    };
    private static final Predicate<String> ISVALID_INT = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Integer.valueOf(s.trim());
            return true;
        }
    };
    private static final Predicate<String> ISVALID_LONG = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Long.valueOf(s.trim());
            return true;
        }
    };
    private static final Predicate<String> ISVALID_SHORT = new Predicate<String>(){

        @Override
        public boolean apply(String s) {
            Short.valueOf(s.trim());
            return true;
        }
    };
    private static final Map<String, Predicate<String>> PRIMITIVE_TO_VALIDATOR = ImmutableMap.builder().put("boolean", ISVALID_BOOLEAN).put("byte", ISVALID_BYTE).put("char", ISVALID_CHAR).put("double", ISVALID_DOUBLE).put("float", ISVALID_FLOAT).put("int", ISVALID_INT).put("long", ISVALID_LONG).put("short", ISVALID_SHORT).build();
    public static final JavaUtil INSTANCE = new JavaUtil();

    private JavaUtil() {
        super(RESERVED_WORDS, FORBIDDEN_OPS, OPS_FINDER, CharEscapers.javaStringUnicodeEscaper(), CharEscapers.javaStringEscaper());
    }

    public static final boolean isPrimitiveType(String s) {
        return PRIMITIVE_TYPES.contains(s);
    }

    private static boolean isIdentifier(String s) {
        return s != null && !RESERVED_WORDS.contains(s) && IDENTIFIER_REGEX.matcher(s).matches();
    }

    public static String validateType(AlertSink alertSink, NativeType type) {
        String ret = type.getNativeType(OutputLanguage.JAVA);
        if (ret == null) {
            alertSink.add(new MissingTypeError(type, OutputLanguage.JAVA));
            return ret;
        }
        ret = ret.replace('{', '<').replace('}', '>').trim();
        LinkedList<String> tokens = new LinkedList<String>();
        String s = type.getNativeType(OutputLanguage.JAVA).trim();
        while (s.length() != 0) {
            Matcher m = TYPE_TOKEN_REGEX.matcher(s);
            if (m.find()) {
                tokens.add(m.group(1));
                s = m.group(2).trim();
                continue;
            }
            alertSink.add(new IllegalJavaTypeError(type));
            return ret;
        }
        if (!JavaUtil.parseType(tokens) || !tokens.isEmpty()) {
            alertSink.add(new IllegalJavaTypeError(type));
        }
        return ret;
    }

    public static String validateConjunctiveType(AlertSink alertSink, NativeType type) {
        ArrayList<String> subTypes = Lists.newArrayList();
        for (String subType : type.getNativeType(OutputLanguage.JAVA).split("&")) {
            subTypes.add(JavaUtil.validateType(alertSink, new NativeType((Node)type, subType)));
        }
        return Join.join(" & ", subTypes);
    }

    public static String validateAnnotation(AlertSink alertSink, JavaAnnotation annotation) {
        return annotation.getWith();
    }

    private static boolean parseType(Queue<String> tokens) {
        if (JavaUtil.isPrimitiveType(tokens.peek())) {
            tokens.poll();
        } else {
            while (true) {
                if (!JavaUtil.isIdentifier(tokens.poll())) {
                    return false;
                }
                if ("<".equals(tokens.peek()) && !JavaUtil.parseTypeArguments(tokens, "<", ">")) {
                    return false;
                }
                if ("{".equals(tokens.peek()) && !JavaUtil.parseTypeArguments(tokens, "{", "}")) {
                    return false;
                }
                if (!".".equals(tokens.peek())) break;
                tokens.poll();
            }
        }
        while ("[".equals(tokens.peek())) {
            tokens.poll();
            if ("]".equals(tokens.poll())) continue;
            return false;
        }
        return true;
    }

    private static boolean parseTypeArguments(Queue<String> tokens, String start, String end) {
        if (!tokens.poll().equals(start)) {
            return false;
        }
        while (true) {
            if (!JavaUtil.parseTypeArgument(tokens)) {
                return false;
            }
            if (!",".equals(tokens.peek())) break;
            tokens.poll();
        }
        return end.equals(tokens.poll());
    }

    private static boolean parseTypeArgument(Queue<String> tokens) {
        if ("?".equals(tokens.peek())) {
            tokens.poll();
            if (TYPE_ARGUMENT_QUALIFIERS.contains(tokens.peek())) {
                tokens.poll();
                return JavaUtil.parseType(tokens);
            }
        } else {
            return JavaUtil.parseType(tokens);
        }
        return true;
    }

    public static String toReferenceType(String type) {
        String result = PRIMITIVE_TO_BOXED_MAP.get(type);
        return result == null ? type : result;
    }

    public static String unbox(String expr, String type) {
        if (PRIMITIVE_TO_BOXED_MAP.containsKey(type)) {
            return "(" + expr + ")." + type + "Value()";
        }
        return expr;
    }

    public static final boolean isValidPrimitive(String primitive, String type) {
        try {
            return PRIMITIVE_TO_VALIDATOR.get(type).apply(primitive);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

