/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.collect;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemovableIterator<T>
extends AbstractIterator<T> {
    private T elementToRemove;
    private boolean canRemove;

    protected abstract void remove(T var1);

    @Override
    public T next() {
        Object element = super.next();
        this.canRemove = true;
        this.elementToRemove = element;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
        try {
            this.remove(this.elementToRemove);
        }
        finally {
            this.elementToRemove = null;
            this.canRemove = false;
        }
    }
}

