/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;
import org.apache.felix.shell.ShellService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HelpCommandImpl
implements Command {
    private BundleContext m_context = null;
    static /* synthetic */ Class class$org$apache$felix$shell$ShellService;

    public HelpCommandImpl(BundleContext context) {
        this.m_context = context;
    }

    public String getName() {
        return "help";
    }

    public String getUsage() {
        return "help [<command> ...]";
    }

    public String getShortDescription() {
        return "display available command usage and description.";
    }

    public void execute(String s, PrintStream out, PrintStream err) {
        try {
            ServiceReference ref = this.m_context.getServiceReference((class$org$apache$felix$shell$ShellService == null ? (class$org$apache$felix$shell$ShellService = HelpCommandImpl.class$("org.apache.felix.shell.ShellService")) : class$org$apache$felix$shell$ShellService).getName());
            if (ref != null) {
                ShellService ss = (ShellService)this.m_context.getService(ref);
                StringTokenizer st = new StringTokenizer(s, " ");
                st.nextToken();
                if (!st.hasMoreTokens()) {
                    String[] cmds = ss.getCommands();
                    for (int i = 0; i < cmds.length; ++i) {
                        out.println(cmds[i]);
                    }
                    out.println("\nUse 'help <command-name>' for more information.");
                } else {
                    String[] cmds = ss.getCommands();
                    String[] targets = new String[st.countTokens()];
                    for (int i = 0; i < targets.length; ++i) {
                        targets[i] = st.nextToken().trim();
                    }
                    boolean found = false;
                    for (int cmdIdx = 0; cmdIdx < cmds.length; ++cmdIdx) {
                        for (int targetIdx = 0; targetIdx < targets.length; ++targetIdx) {
                            if (!cmds[cmdIdx].equals(targets[targetIdx])) continue;
                            if (found) {
                                out.println("---");
                            }
                            found = true;
                            out.println("Command     : " + cmds[cmdIdx]);
                            out.println("Usage       : " + ss.getCommandUsage(cmds[cmdIdx]));
                            out.println("Description : " + ss.getCommandDescription(cmds[cmdIdx]));
                        }
                    }
                }
            } else {
                err.println("No ShellService is unavailable.");
            }
        }
        catch (Exception ex) {
            err.println(ex.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

