/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.spout;

import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.topology.state.RotatingTransactionalState;
import org.apache.storm.trident.topology.state.TransactionalState;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentSpoutCoordinator
implements IBasicBolt {
    public static final Logger LOG = LoggerFactory.getLogger(TridentSpoutCoordinator.class);
    private static final String META_DIR = "meta";
    ITridentSpout<Object> spout;
    ITridentSpout.BatchCoordinator<Object> coord;
    RotatingTransactionalState state;
    TransactionalState underlyingState;
    String id;

    public TridentSpoutCoordinator(String id, ITridentSpout<Object> spout) {
        this.spout = spout;
        this.id = id;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context) {
        this.coord = this.spout.getCoordinator(this.id, conf, context);
        this.underlyingState = TransactionalState.newCoordinatorState(conf, this.id);
        this.state = new RotatingTransactionalState(this.underlyingState, META_DIR);
    }

    @Override
    public void execute(Tuple tuple, BasicOutputCollector collector) {
        TransactionAttempt attempt = (TransactionAttempt)tuple.getValue(0);
        if (tuple.getSourceStreamId().equals("$success")) {
            this.state.cleanupBefore(attempt.getTransactionId());
            this.coord.success(attempt.getTransactionId());
        } else {
            long txid = attempt.getTransactionId();
            Object prevMeta = this.state.getPreviousState(txid);
            Object meta = this.coord.initializeTransaction(txid, prevMeta, this.state.getState(txid));
            this.state.overrideState(txid, meta);
            collector.emit("$batch", new Values(attempt, meta));
        }
    }

    @Override
    public void cleanup() {
        this.coord.close();
        this.underlyingState.close();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream("$batch", new Fields("tx", "metadata"));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Config ret = new Config();
        ret.setMaxTaskParallelism(1);
        return ret;
    }
}

