/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.MessageDecoder;
import org.apache.storm.messaging.netty.NettySerializableMessageEncoder;
import org.apache.storm.messaging.netty.SaslStormClientHandler;
import org.apache.storm.messaging.netty.StormClientHandler;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.ChannelInitializer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.apache.storm.shade.io.netty.handler.ssl.SslContext;

class StormClientPipelineFactory
extends ChannelInitializer<Channel> {
    private final Client client;
    private final AtomicBoolean[] remoteBpStatus;
    private final Map<String, Object> conf;
    private final SslContext sslContext;

    StormClientPipelineFactory(Client client, AtomicBoolean[] remoteBpStatus, Map<String, Object> conf, SslContext sslContext) {
        this.client = client;
        this.remoteBpStatus = remoteBpStatus;
        this.conf = conf;
        this.sslContext = sslContext;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContext != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        pipeline.addLast("decoder", (ChannelHandler)new MessageDecoder(new KryoValuesDeserializer(this.conf)));
        pipeline.addLast("encoder", (ChannelHandler)NettySerializableMessageEncoder.INSTANCE);
        boolean isNettyAuth = (Boolean)this.conf.get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslClientHandler", (ChannelHandler)new SaslStormClientHandler(this.client));
        }
        pipeline.addLast("handler", (ChannelHandler)new StormClientHandler(this.client, this.remoteBpStatus, this.conf));
    }
}

