/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.metrics.RegionScanMetricsData;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsRegionInfo;
import org.apache.hadoop.hbase.client.metrics.ScanMetricsUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerSideScanMetrics {
    private final Map<String, AtomicLong> counters = new HashMap<String, AtomicLong>();
    private final List<RegionScanMetricsData> regionScanMetricsData = new ArrayList<RegionScanMetricsData>(0);
    protected RegionScanMetricsData currentRegionScanMetricsData = null;
    public static final String COUNT_OF_ROWS_SCANNED_KEY_METRIC_NAME = "ROWS_SCANNED";
    public static final String COUNT_OF_ROWS_FILTERED_KEY_METRIC_NAME = "ROWS_FILTERED";
    public static final String BLOCK_BYTES_SCANNED_KEY_METRIC_NAME = "BLOCK_BYTES_SCANNED";
    public static final String FS_READ_TIME_METRIC_NAME = "FS_READ_TIME";
    @Deprecated
    public static final String COUNT_OF_ROWS_SCANNED_KEY = "ROWS_SCANNED";
    @Deprecated
    public static final String COUNT_OF_ROWS_FILTERED_KEY = "ROWS_FILTERED";
    public final AtomicLong countOfRowsFiltered = this.createCounter("ROWS_FILTERED");
    public final AtomicLong countOfRowsScanned = this.createCounter("ROWS_SCANNED");
    public final AtomicLong countOfBlockBytesScanned = this.createCounter("BLOCK_BYTES_SCANNED");
    public final AtomicLong fsReadTime = this.createCounter("FS_READ_TIME");

    public void moveToNextRegion() {
        this.currentRegionScanMetricsData = new RegionScanMetricsData();
        this.regionScanMetricsData.add(this.currentRegionScanMetricsData);
        this.currentRegionScanMetricsData.createCounter("ROWS_SCANNED");
        this.currentRegionScanMetricsData.createCounter("ROWS_FILTERED");
        this.currentRegionScanMetricsData.createCounter(BLOCK_BYTES_SCANNED_KEY_METRIC_NAME);
        this.currentRegionScanMetricsData.createCounter(FS_READ_TIME_METRIC_NAME);
    }

    protected AtomicLong createCounter(String counterName) {
        return ScanMetricsUtil.createCounter(this.counters, counterName);
    }

    public void setCounter(String counterName, long value) {
        ScanMetricsUtil.setCounter(this.counters, counterName, value);
        if (this.currentRegionScanMetricsData != null) {
            this.currentRegionScanMetricsData.setCounter(counterName, value);
        }
    }

    public boolean hasCounter(String counterName) {
        return ScanMetricsUtil.hasCounter(this.counters, counterName);
    }

    public AtomicLong getCounter(String counterName) {
        return ScanMetricsUtil.getCounter(this.counters, counterName);
    }

    public void addToCounter(String counterName, long delta) {
        ScanMetricsUtil.addToCounter(this.counters, counterName, delta);
        if (this.currentRegionScanMetricsData != null) {
            this.currentRegionScanMetricsData.addToCounter(counterName, delta);
        }
    }

    public Map<String, Long> getMetricsMap() {
        return this.getMetricsMap(true);
    }

    public Map<String, Long> getMetricsMap(boolean reset) {
        return ImmutableMap.copyOf(ScanMetricsUtil.collectMetrics(this.counters, reset));
    }

    public Map<ScanMetricsRegionInfo, Map<String, Long>> collectMetricsByRegion() {
        return this.collectMetricsByRegion(true);
    }

    public Map<ScanMetricsRegionInfo, Map<String, Long>> collectMetricsByRegion(boolean reset) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RegionScanMetricsData regionScanMetricsData : this.regionScanMetricsData) {
            if (regionScanMetricsData.getScanMetricsRegionInfo() == ScanMetricsRegionInfo.EMPTY_SCAN_METRICS_REGION_INFO) continue;
            builder.put((Object)regionScanMetricsData.getScanMetricsRegionInfo(), regionScanMetricsData.collectMetrics(reset));
        }
        return builder.build();
    }

    public String toString() {
        return this.counters + "," + this.regionScanMetricsData.stream().map(RegionScanMetricsData::toString).collect(Collectors.joining(","));
    }

    public void initScanMetricsRegionInfo(String encodedRegionName, ServerName serverName) {
        this.currentRegionScanMetricsData.initScanMetricsRegionInfo(encodedRegionName, serverName);
    }
}

