/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.ThriftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThriftServer<T extends ThriftServer> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiThriftServer.class);
    private final String name;
    private final Map<ThriftConnectionType, T> thriftServerMap = new HashMap<ThriftConnectionType, T>();
    private final Map<ThriftConnectionType, Thread> thriftServerThreadMap = new HashMap<ThriftConnectionType, Thread>();
    private final Map<ThriftConnectionType, Boolean> thriftServerIsServingMap = new HashMap<ThriftConnectionType, Boolean>();

    public MultiThriftServer(String name) {
        this.name = name;
    }

    public void add(T thriftServer) {
        this.thriftServerMap.put(((ThriftServer)thriftServer).getType(), thriftServer);
        this.thriftServerThreadMap.put(((ThriftServer)thriftServer).getType(), new Thread(() -> thriftServer.serve(), this.name + "-" + ((ThriftServer)thriftServer).getPort()));
    }

    public void serve() {
        for (ThriftServer thriftServer : this.thriftServerMap.values()) {
            if (Boolean.TRUE.equals(this.thriftServerIsServingMap.get((Object)thriftServer.getType()))) {
                throw new IllegalStateException("The MultiThriftServer " + this.thriftServerThreadMap.get((Object)thriftServer.getType()).getName() + " is already serving");
            }
            LOG.info("Starting thrift server {}", (Object)this.thriftServerThreadMap.get((Object)thriftServer.getType()).getName());
            this.thriftServerThreadMap.get((Object)thriftServer.getType()).start();
            this.thriftServerIsServingMap.put(thriftServer.getType(), true);
        }
    }

    public void stop() {
        for (ThriftServer thriftServer : this.thriftServerMap.values()) {
            if (Boolean.TRUE.equals(this.thriftServerIsServingMap.get((Object)thriftServer.getType()))) {
                this.thriftServerThreadMap.get((Object)thriftServer.getType()).interrupt();
                ((ThriftServer)this.thriftServerMap.get((Object)thriftServer.getType())).stop();
                this.thriftServerIsServingMap.put(thriftServer.getType(), false);
                continue;
            }
            LOG.warn("Can't stop the " + this.thriftServerThreadMap.get((Object)thriftServer.getType()).getName() + " server since it is not currently serving");
        }
    }

    public void stopTlsServer(ThriftConnectionType tlsConnectionType) {
        if (Boolean.TRUE.equals(this.thriftServerIsServingMap.get((Object)tlsConnectionType))) {
            this.thriftServerThreadMap.get((Object)tlsConnectionType).interrupt();
            ((ThriftServer)this.thriftServerMap.get((Object)tlsConnectionType)).stop();
            this.thriftServerIsServingMap.put(tlsConnectionType, false);
        } else {
            LOG.warn("Can't stop the " + String.valueOf((Object)tlsConnectionType) + " server since it is not currently serving");
        }
    }

    public boolean supportsWorkerTokens() {
        for (ThriftServer server : this.thriftServerMap.values()) {
            if (!server.supportsWorkerTokens()) continue;
            return true;
        }
        return false;
    }

    public T get(ThriftConnectionType type) {
        return (T)((ThriftServer)this.thriftServerMap.get((Object)type));
    }
}

