/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.util.Map;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.daemon.drpc.DRPC;
import org.apache.storm.daemon.drpc.DRPCThrift;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ServiceRegistry;

public class LocalDRPC
implements ILocalDRPC {
    private final DRPC drpc;
    private final String serviceId;

    public LocalDRPC() {
        this(new StormMetricsRegistry());
    }

    public LocalDRPC(StormMetricsRegistry metricsRegistry) {
        Map conf = ConfigUtils.readStormConfig();
        this.drpc = new DRPC(metricsRegistry, conf);
        this.serviceId = ServiceRegistry.registerService((Object)new DRPCThrift(this.drpc));
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void result(String id, String result) throws AuthorizationException, TException {
        this.drpc.returnResult(id, result);
    }

    public String execute(String functionName, String funcArgs) throws DRPCExecutionException, AuthorizationException, TException {
        return this.drpc.executeBlocking(functionName, funcArgs);
    }

    public void failRequest(String id) throws AuthorizationException, TException {
        this.drpc.failRequest(id, null);
    }

    public void failRequestV2(String id, DRPCExecutionException e) throws AuthorizationException, TException {
        this.drpc.failRequest(id, e);
    }

    public DRPCRequest fetchRequest(String functionName) throws AuthorizationException, TException {
        return this.drpc.fetchRequest(functionName);
    }

    public void close() {
        ServiceRegistry.unregisterService((String)this.serviceId);
        this.drpc.close();
    }

    public void shutdown() {
        this.close();
    }
}

