/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.permutation;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.IntegerPermutationIter;
import org.apache.storm.shade.org.jgrapht.util.MathUtil;

public class CompoundPermutationIter
implements ArrayPermutationsIter,
Iterator {
    IntegerPermutationIter[] permArray;
    private int totalPermArraySize;
    private int max;
    private int iterCounter = 0;

    public CompoundPermutationIter(int[] equalityGroupsSizesArray) {
        this.init(equalityGroupsSizesArray);
    }

    private void init(int[] equalityGroupsSizesArray) {
        this.permArray = new IntegerPermutationIter[equalityGroupsSizesArray.length];
        int counter = 0;
        this.max = 1;
        for (int eqGroup = 0; eqGroup < equalityGroupsSizesArray.length; ++eqGroup) {
            int currGroupSize = equalityGroupsSizesArray[eqGroup];
            int[] currArray = new int[currGroupSize];
            for (int i = 0; i < currGroupSize; ++i) {
                currArray[i] = counter++;
            }
            this.permArray[eqGroup] = new IntegerPermutationIter(currArray);
            this.permArray[eqGroup].getNext();
            this.max = (int)((long)this.max * MathUtil.factorial(currGroupSize));
        }
        this.totalPermArraySize = counter;
    }

    public Object next() {
        return this.getNext();
    }

    public int[] getNext() {
        if (this.iterCounter == 0) {
            ++this.iterCounter;
            return this.getPermAsArray();
        }
        int firstGroupCapableOfAdvancing = -1;
        int currGroupIndex = 0;
        while (firstGroupCapableOfAdvancing == -1) {
            IntegerPermutationIter currGroup = this.permArray[currGroupIndex];
            if (currGroup.hasNext()) {
                currGroup.getNext();
                for (int i = 0; i < currGroupIndex; ++i) {
                    this.restartPermutationGroup(i);
                }
                firstGroupCapableOfAdvancing = currGroupIndex;
            }
            if (++currGroupIndex < this.permArray.length) continue;
            break;
        }
        ++this.iterCounter;
        if (firstGroupCapableOfAdvancing == -1) {
            return null;
        }
        int[] tempArray = this.getPermAsArray();
        return tempArray;
    }

    public int[] getPermAsArray() {
        int[] resultArray = new int[this.totalPermArraySize];
        int counter = 0;
        for (int groupIndex = 0; groupIndex < this.permArray.length; ++groupIndex) {
            int[] currPermArray = this.permArray[groupIndex].getCurrent();
            System.arraycopy(currPermArray, 0, resultArray, counter, currPermArray.length);
            counter += currPermArray.length;
        }
        return resultArray;
    }

    private void restartPermutationGroup(int groupIndex) {
        int[] oldPermArray = this.permArray[groupIndex].getCurrent();
        Arrays.sort(oldPermArray);
        this.permArray[groupIndex] = new IntegerPermutationIter(oldPermArray);
        this.permArray[groupIndex].getNext();
    }

    @Override
    public boolean hasNext() {
        boolean result = this.iterCounter < this.max;
        return result;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public int[] nextPermutation() {
        return (int[])this.next();
    }

    @Override
    public boolean hasNextPermutaions() {
        return this.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

