/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.sling.jcr.resource.internal.helper.LazyInputStream;
import org.apache.sling.jcr.resource.internal.helper.ZonedDateTimeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JcrResourceUtil {
    private JcrResourceUtil() {
    }

    @NotNull
    public static QueryResult query(@NotNull Session session, @NotNull String query, @NotNull String language) throws RepositoryException {
        QueryManager qManager = session.getWorkspace().getQueryManager();
        Query q = qManager.createQuery(query, language);
        return q.execute();
    }

    @NotNull
    public static Object toJavaObject(@NotNull Value value) throws RepositoryException {
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    @NotNull
    public static Object toJavaObject(@NotNull Property property) throws RepositoryException {
        if (property.isMultiple()) {
            Value[] values = property.getValues();
            Object firstValue = values.length > 0 ? JcrResourceUtil.toJavaObject(values[0]) : null;
            Object[] result = JcrResourceUtil.createArray(firstValue, values.length);
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value == null) continue;
                result[i] = JcrResourceUtil.toJavaObject(value);
            }
            return result;
        }
        return JcrResourceUtil.toJavaObject(property.getValue());
    }

    @NotNull
    private static Object[] createArray(@Nullable Object firstValue, int length) {
        Object[] result = firstValue instanceof Boolean ? new Boolean[length] : (firstValue instanceof Calendar ? new Calendar[length] : (firstValue instanceof Double ? new Double[length] : (firstValue instanceof Long ? new Long[length] : (firstValue instanceof BigDecimal ? new BigDecimal[length] : (firstValue instanceof InputStream ? new Object[length] : new String[length])))));
        return result;
    }

    @Nullable
    public static Value createValue(@NotNull Object value, @NotNull Session session) throws RepositoryException {
        ValueFactory fac = session.getValueFactory();
        Object val = value instanceof ZonedDateTime ? fac.createValue(new ZonedDateTimeConverter((ZonedDateTime)value).toCalendar()) : (value instanceof Calendar ? fac.createValue((Calendar)value) : (value instanceof InputStream ? fac.createValue(fac.createBinary((InputStream)value)) : (value instanceof Node ? fac.createValue((Node)value) : (value instanceof BigDecimal ? fac.createValue((BigDecimal)value) : (value instanceof Long ? fac.createValue(((Long)value).longValue()) : (value instanceof Short ? fac.createValue((long)((Short)value).shortValue()) : (value instanceof Integer ? fac.createValue((long)((Integer)value).intValue()) : (value instanceof Number ? fac.createValue(((Number)value).doubleValue()) : (value instanceof Boolean ? fac.createValue(((Boolean)value).booleanValue()) : (value instanceof String ? fac.createValue((String)value) : null))))))))));
        return val;
    }
}

