/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.helpers.lazyloading;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyLoadingMap<K, T>
extends HashMap<K, T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<K, Supplier<T>> suppliers = new HashMap<K, Supplier<T>>();
    private boolean computeValueOnRemove;
    private boolean forbidComputeAll;
    private final Stats stats = new Stats();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LazyLoadingMap)) {
            return false;
        }
        LazyLoadingMap other = (LazyLoadingMap)o;
        this.computeAll();
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.suppliers.hashCode();
    }

    @Override
    public Supplier<T> put(K key, Supplier<T> supplier) {
        super.remove(key);
        return this.suppliers.put(key, supplier);
    }

    @Override
    public T get(Object key) {
        this.computeIfAbsent(key, k -> {
            Supplier<T> s = this.suppliers.remove(k);
            if (s != null) {
                ++this.stats.suppliersCallCount;
                return s.get();
            }
            return null;
        });
        return (T)super.get(key);
    }

    @Override
    public T remove(Object key) {
        Supplier<T> supplier = this.suppliers.remove(key);
        Object oldValue = super.remove(key);
        if (this.computeValueOnRemove) {
            if (supplier != null) {
                ++this.stats.suppliersCallCount;
                return supplier.get();
            }
            return (T)oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.suppliers.clear();
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.suppliers.containsKey(key);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.suppliers.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> result = new HashSet<K>();
        result.addAll(super.keySet());
        result.addAll(this.suppliers.keySet());
        return result;
    }

    private void computeAll() {
        if (this.forbidComputeAll) {
            throw new RuntimeException("The computeAll() method has been disabled by the computeAllThrowsException option");
        }
        if (!this.suppliers.isEmpty()) {
            this.log.debug("computeAll called, all remaining lazy values will be evaluated now");
            HashSet<K> keys = new HashSet<K>(this.suppliers.keySet());
            keys.forEach(this::get);
        }
    }

    @Override
    public Collection<T> values() {
        this.computeAll();
        return super.values();
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        this.computeAll();
        return super.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        this.computeAll();
        return super.containsValue(value);
    }

    public Stats getStats() {
        return this.stats;
    }

    public LazyLoadingMap<K, T> computeValueOnRemove(boolean b) {
        this.computeValueOnRemove = b;
        return this;
    }

    public LazyLoadingMap<K, T> computeAllThrowsException(boolean b) {
        this.forbidComputeAll = b;
        return this;
    }

    public class Stats {
        int suppliersCallCount;

        public int getSuppliersCallCount() {
            return this.suppliersCallCount;
        }

        public int getUnusedSuppliersCount() {
            return LazyLoadingMap.this.suppliers.size();
        }
    }
}

