/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.graphql.api.SelectionSet;
import org.apache.sling.graphql.core.engine.SelectedFieldWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionSetWrapper
implements SelectionSet {
    private List<org.apache.sling.graphql.api.SelectedField> fields = new ArrayList<org.apache.sling.graphql.api.SelectedField>();
    private Map<String, org.apache.sling.graphql.api.SelectedField> fieldsMap = new HashMap<String, org.apache.sling.graphql.api.SelectedField>();

    public SelectionSetWrapper(@Nullable DataFetchingFieldSelectionSet selectionSet) {
        if (selectionSet != null) {
            selectionSet.getImmediateFields().forEach(sf -> {
                String name = sf.getName();
                SelectedFieldWrapper selectedField = new SelectedFieldWrapper((SelectedField)sf);
                if (!this.fieldsMap.containsKey(name)) {
                    this.fieldsMap.put(name, selectedField);
                    if (!name.contains("/")) {
                        this.fields.add(selectedField);
                    }
                }
            });
            this.initFlatMap(this.fields, "");
        }
    }

    private void initFlatMap(List<org.apache.sling.graphql.api.SelectedField> parentList, String qualifiedPath) {
        parentList.forEach(s -> {
            String qualifiedName = qualifiedPath + s.getName();
            if (!this.fieldsMap.containsKey(qualifiedName)) {
                this.fieldsMap.put(qualifiedName, (org.apache.sling.graphql.api.SelectedField)s);
            }
            this.initFlatMap(s.getSubSelectedFields(), qualifiedName + "/");
        });
    }

    @Override
    @NotNull
    public List<org.apache.sling.graphql.api.SelectedField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public boolean contains(String qualifiedName) {
        return this.fieldsMap.containsKey(qualifiedName);
    }

    @Override
    public org.apache.sling.graphql.api.SelectedField get(String qualifiedName) {
        return this.fieldsMap.get(qualifiedName);
    }
}

