/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.servlet;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Filter.class}, property={"service.description=Duplicate replication agents IDs checking Filter", "service.vendor=The Apache Software Foundation", "sling.filter.scope=request", "sling.filter.pattern=/libs/sling/distribution/settings/agents/.*", "osgi.http.whiteboard.filter.regex=/libs/sling/distribution/settings/agents/.*", "service.ranking=2147483647"})
public final class DistributionAgentCreationFilter
implements Filter {
    private static final String METHOD_POST = "POST";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String FACTORY_FILTER_PATTERN = "(&(name=%s)(!(type=%s)))";
    private BundleContext context;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest servletRequest = (SlingHttpServletRequest)request;
        if (METHOD_POST.equalsIgnoreCase(servletRequest.getMethod())) {
            String name = request.getParameter(NAME);
            String type = request.getParameter(TYPE);
            if (type != null && name != null) {
                String filter = String.format(FACTORY_FILTER_PATTERN, name, type);
                try {
                    Collection services = this.context.getServiceReferences(DistributionAgent.class, filter);
                    if (!services.isEmpty()) {
                        String errorMessage = String.format("An agent named '%s' of different type than '%s' was already previously registered, please change the Agent name.", name, type);
                        ((HttpServletResponse)response).sendError(409, errorMessage);
                        return;
                    }
                }
                catch (InvalidSyntaxException e) {
                    this.log.error("Impossible to access to {} references", (Object)DistributionAgent.class.getName(), (Object)e);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

