/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.impl.simple.QueueItemMapper;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleDistributionQueueCheckpoint
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributionQueueCheckpoint.class);
    private final DistributionQueue queue;
    private final File checkpointDirectory;

    public SimpleDistributionQueueCheckpoint(DistributionQueue queue, File checkpointDirectory) {
        this.queue = queue;
        this.checkpointDirectory = checkpointDirectory;
    }

    @Override
    public void run() {
        String fileName = this.queue.getName() + "-checkpoint";
        File checkpointFile = new File(this.checkpointDirectory, fileName + "-new");
        QueueItemMapper mapper = new QueueItemMapper();
        log.debug("started checkpointing");
        try {
            if (checkpointFile.exists()) assert (checkpointFile.delete());
            assert (checkpointFile.createNewFile());
            LinkedList<String> lines = new LinkedList<String>();
            FileOutputStream fileOutputStream = new FileOutputStream(checkpointFile);
            for (DistributionQueueEntry queueEntry : this.queue.getEntries(0, -1)) {
                DistributionQueueItem item = queueEntry.getItem();
                String line = mapper.writeQueueItem(item);
                lines.add(line);
            }
            log.debug("parsed {} items", (Object)lines.size());
            IOUtils.writeLines(lines, null, (OutputStream)fileOutputStream, (Charset)Charset.defaultCharset());
            fileOutputStream.flush();
            fileOutputStream.close();
            boolean success = checkpointFile.renameTo(new File(this.checkpointDirectory, fileName));
            log.debug("checkpoint succeeded: {}", (Object)success);
        }
        catch (Exception e) {
            log.error("failed checkpointing for queue {}", (Object)this.queue.getName());
        }
    }
}

