/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.spi.base.AbstractServiceWithBackgroundCheck;
import org.apache.sling.discovery.commons.providers.spi.base.ClusterSyncHistory;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptor;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.commons.providers.util.LogSilencer;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ClusterSyncService.class, OakBacklogClusterSyncService.class}, property={"service.vendor=The Apache Software Foundation"})
public class OakBacklogClusterSyncService
extends AbstractServiceWithBackgroundCheck
implements ClusterSyncService {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private IdMapService idMapService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected DiscoveryLiteConfig commonsConfig;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected SlingSettingsService settingsService;
    private ClusterSyncHistory consistencyHistory = new ClusterSyncHistory();
    private final LogSilencer logSilencer = new LogSilencer(this.logger);

    public static OakBacklogClusterSyncService testConstructorAndActivate(DiscoveryLiteConfig commonsConfig, IdMapService idMapService, SlingSettingsService settingsService, ResourceResolverFactory resourceResolverFactory) {
        OakBacklogClusterSyncService service = OakBacklogClusterSyncService.testConstructor(commonsConfig, idMapService, settingsService, resourceResolverFactory);
        service.activate();
        return service;
    }

    public static OakBacklogClusterSyncService testConstructor(DiscoveryLiteConfig commonsConfig, IdMapService idMapService, SlingSettingsService settingsService, ResourceResolverFactory resourceResolverFactory) {
        OakBacklogClusterSyncService service = new OakBacklogClusterSyncService();
        if (commonsConfig == null) {
            throw new IllegalArgumentException("commonsConfig must not be null");
        }
        if (resourceResolverFactory == null) {
            throw new IllegalArgumentException("resourceResolverFactory must not be null");
        }
        if (settingsService == null) {
            throw new IllegalArgumentException("settingsService must not be null");
        }
        service.commonsConfig = commonsConfig;
        service.resourceResolverFactory = resourceResolverFactory;
        service.idMapService = idMapService;
        service.settingsService = settingsService;
        return service;
    }

    @Activate
    protected void activate() {
        this.slingId = this.getSettingsService().getSlingId();
        this.logger.info("activate: activated with slingId=" + this.slingId);
    }

    public void setConsistencyHistory(ClusterSyncHistory consistencyHistory) {
        this.consistencyHistory = consistencyHistory;
    }

    public ClusterSyncHistory getConsistencyHistory() {
        return this.consistencyHistory;
    }

    protected ResourceResolver getResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    @Override
    public void cancelSync() {
        this.cancelPreviousBackgroundCheck();
    }

    @Override
    public void sync(BaseTopologyView view, Runnable callback) {
        this.cancelPreviousBackgroundCheck();
        this.logSilencer.infoOrDebug("sync", "sync: doing wait-for-backlog part for view=" + view.toShortString());
        this.waitWhileBacklog(view, callback);
    }

    private void waitWhileBacklog(final BaseTopologyView view, Runnable runnable) {
        this.startBackgroundCheck("OakBacklogClusterSyncService-backlog-waiting-" + view.getLocalClusterSyncTokenId(), new AbstractServiceWithBackgroundCheck.BackgroundCheck(){

            @Override
            public boolean check() {
                try {
                    if (!OakBacklogClusterSyncService.this.idMapService.isInitialized()) {
                        OakBacklogClusterSyncService.this.logSilencer.infoOrDebug("waitWhileBacklog-" + view.toShortString(), "waitWhileBacklog: could not initialize...");
                        OakBacklogClusterSyncService.this.consistencyHistory.addHistoryEntry(view, "could not initialize idMapService");
                        return false;
                    }
                }
                catch (Exception e) {
                    OakBacklogClusterSyncService.this.logger.error("waitWhileBacklog: could not initialized due to " + String.valueOf(e), (Throwable)e);
                    OakBacklogClusterSyncService.this.consistencyHistory.addHistoryEntry(view, "got Exception while initializing idMapService (" + String.valueOf(e) + ")");
                    return false;
                }
                BacklogStatus backlogStatus = OakBacklogClusterSyncService.this.getBacklogStatus(view);
                if (backlogStatus == BacklogStatus.NO_BACKLOG) {
                    OakBacklogClusterSyncService.this.logSilencer.infoOrDebug("waitWhileBacklog-" + view.toShortString(), "waitWhileBacklog: no backlog (anymore), done.");
                    OakBacklogClusterSyncService.this.consistencyHistory.addHistoryEntry(view, "no backlog (anymore)");
                    return true;
                }
                OakBacklogClusterSyncService.this.logSilencer.infoOrDebug("waitWhileBacklog-" + view.toShortString(), "waitWhileBacklog: backlogStatus still " + String.valueOf((Object)backlogStatus));
                OakBacklogClusterSyncService.this.idMapService.clearCache();
                OakBacklogClusterSyncService.this.consistencyHistory.addHistoryEntry(view, "backlog status " + String.valueOf((Object)backlogStatus));
                return false;
            }
        }, runnable, this.getCommonsConfig().getClusterSyncServiceTimeoutMillis(), this.getCommonsConfig().getClusterSyncServiceIntervalMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BacklogStatus getBacklogStatus(BaseTopologyView view) {
        this.logger.trace("getBacklogStatus: start");
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            DiscoveryLiteDescriptor descriptor = DiscoveryLiteDescriptor.getDescriptorFrom(resourceResolver);
            int[] activeIds = descriptor.getActiveIds();
            int[] deactivatingIds = descriptor.getDeactivatingIds();
            if (deactivatingIds.length != 0) {
                this.logSilencer.infoOrDebug("getBacklogStatus-hasBacklog-" + view.toShortString(), "getBacklogStatus: there are deactivating instances: " + Arrays.toString(deactivatingIds));
                BacklogStatus backlogStatus = BacklogStatus.HAS_BACKLOG;
                return backlogStatus;
            }
            ClusterView cluster = view.getLocalInstance().getClusterView();
            LocalClusterView localCluster = null;
            if (cluster instanceof LocalClusterView) {
                localCluster = (LocalClusterView)cluster;
            }
            HashSet<String> slingIds = new HashSet<String>();
            for (InstanceDescription instance : cluster.getInstances()) {
                slingIds.add(instance.getSlingId());
            }
            for (int i = 0; i < activeIds.length; ++i) {
                int activeId = activeIds[i];
                if (localCluster != null && localCluster.isPartiallyStarted(activeId)) continue;
                String slingId = this.idMapService.toSlingId(activeId, resourceResolver);
                if (slingId == null) {
                    this.logSilencer.infoOrDebug("getBacklogStatus-undefined-" + view.toShortString(), "getBacklogStatus: no slingId found for active id: " + activeId);
                    BacklogStatus backlogStatus = BacklogStatus.UNDEFINED;
                    return backlogStatus;
                }
                if (slingIds.contains(slingId)) continue;
                this.logSilencer.infoOrDebug("getBacklogStatus-hasBacklog-" + view.toShortString(), "getBacklogStatus: active instance's (" + activeId + ") slingId (" + slingId + ") not found in cluster (" + String.valueOf(cluster) + ")");
                BacklogStatus backlogStatus = BacklogStatus.HAS_BACKLOG;
                return backlogStatus;
            }
            this.logSilencer.infoOrDebug("getBacklogStatus-" + view.toShortString(), "getBacklogStatus: no backlog (anymore)");
            BacklogStatus backlogStatus = BacklogStatus.NO_BACKLOG;
            return backlogStatus;
        }
        catch (Exception e) {
            this.logSilencer.infoOrDebug("getBacklogStatus-undefined-" + view.toShortString(), "getBacklogStatus: failed to determine backlog status: " + String.valueOf(e));
            BacklogStatus backlogStatus = BacklogStatus.UNDEFINED;
            return backlogStatus;
        }
        finally {
            this.logger.trace("getBacklogStatus: end");
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected DiscoveryLiteConfig getCommonsConfig() {
        return this.commonsConfig;
    }

    protected SlingSettingsService getSettingsService() {
        return this.settingsService;
    }

    public List<String> getSyncHistory() {
        return this.consistencyHistory.getSyncHistory();
    }

    static enum BacklogStatus {
        UNDEFINED,
        HAS_BACKLOG,
        NO_BACKLOG;

    }
}

