/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.rest.vertx.AbstractVertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdgeDispatcher
extends AbstractVertxHttpDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEdgeDispatcher.class);

    protected void onFailure(RoutingContext context) {
        LOGGER.error("edge server failed.", context.failure());
        HttpServerResponse response = context.response();
        if (response.closed() || response.ended()) {
            return;
        }
        if (context.failure() instanceof InvocationException) {
            String responseBody;
            InvocationException exception = (InvocationException)context.failure();
            response.setStatusCode(exception.getStatusCode());
            response.setStatusMessage(exception.getReasonPhrase());
            if (null == exception.getErrorData()) {
                response.end();
                return;
            }
            try {
                responseBody = RestObjectMapperFactory.getRestObjectMapper().writeValueAsString(exception.getErrorData());
                response.putHeader("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                responseBody = exception.getErrorData().toString();
                response.putHeader("Content-Type", "text/plain");
            }
            response.end(responseBody);
        } else {
            response.setStatusCode(Response.Status.BAD_GATEWAY.getStatusCode());
            response.setStatusMessage(Response.Status.BAD_GATEWAY.getReasonPhrase());
            response.end();
        }
    }
}

