/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.servicecomb.foundation.common.utils.bean.CharGetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class StringWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Character.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new CharFieldStringSchema(protoField, propertyDescriptor);
        }
        if (String.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new StringSchema(protoField, propertyDescriptor);
        }
        return new StringSchema(protoField, propertyDescriptor);
    }

    private static class CharFieldStringSchema<T>
    extends StringDynamicSchema<T> {
        protected final CharGetter<T> getter;

        public CharFieldStringSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (CharGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            char value = this.getter.get(message);
            this.writeTo(output, Character.valueOf(value));
        }
    }

    private static class StringSchema<T>
    extends StringDynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public StringSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class StringDynamicSchema<T>
    extends FieldSchema<T> {
        public StringDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof String) {
                output.writeScalarString(this.tag, this.tagSize, (String)value);
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                output.writeScalarString(this.tag, this.tagSize, ((String[])value)[0]);
                return;
            }
            if (value instanceof Character) {
                output.writeScalarString(this.tag, this.tagSize, String.valueOf(((Character)value).charValue()));
                return;
            }
            if (value instanceof BigDecimal || value instanceof BigInteger) {
                output.writeScalarString(this.tag, this.tagSize, value.toString());
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

