/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecsUtils;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class HeaderProcessorCreator
implements ParamValueProcessorCreator<Parameter> {
    public static final String PARAMTYPE = "header";

    public HeaderProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(OperationMeta operationMeta, String parameterName, Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new HeaderProcessor((HeaderParameter)parameter, targetType);
    }

    public static class HeaderProcessor
    extends AbstractParamProcessor {
        private final boolean ignoreRequiredCheck = LegacyPropertyFactory.getBooleanProperty((String)"servicecomb.rest.parameter.header.ignoreRequiredCheck", (boolean)false);
        private final HeaderCodec headerCodec;

        public HeaderProcessor(HeaderParameter headerParameter, JavaType targetType) {
            super(headerParameter.getName(), targetType, headerParameter.getSchema().getDefault(), headerParameter.getRequired() != null && headerParameter.getRequired() != false);
            this.headerCodec = headerParameter.getSchema() instanceof ArraySchema && headerParameter.getStyle() == null ? HeaderCodecsUtils.find(Parameter.StyleEnum.FORM, true) : HeaderCodecsUtils.find(headerParameter.getStyle(), headerParameter.getExplode());
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            return this.headerCodec.decode(this, request);
        }

        public Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            this.headerCodec.encode(clientRequest, this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return HeaderProcessorCreator.PARAMTYPE;
        }
    }
}

