/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.DynamicPropertyFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.edge.core.EdgeRestServerVerticle;
import org.apache.servicecomb.edge.core.EdgeRestTransportClient;
import org.apache.servicecomb.transport.rest.client.TransportClientConfig;
import org.apache.servicecomb.transport.rest.vertx.TransportConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EdgeBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBootListener.class);

    public void onBootEvent(BootListener.BootEvent event) {
        if (!BootListener.EventType.BEFORE_PRODUCER_PROVIDER.equals((Object)event.getEventType())) {
            return;
        }
        TransportClientConfig.setRestTransportClientCls(EdgeRestTransportClient.class);
        TransportConfig.setRestServerVerticle(EdgeRestServerVerticle.class);
        String defaultExecutor = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.executors.default", null).get();
        if (defaultExecutor != null) {
            LOGGER.info("Edge service default executor is {}.", (Object)defaultExecutor);
            return;
        }
        Configuration configuration = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();
        configuration.setProperty("servicecomb.executors.default", (Object)"servicecomb.executor.reactive");
        LOGGER.info("Set ReactiveExecutor to be edge service default executor.");
    }
}

