/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.meter;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.servicecomb.foundation.metrics.meter.AbstractPeriodMeter;

public class SimpleTimer
extends AbstractPeriodMeter {
    private static final double CNV_SECONDS = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private final Id idCount;
    private final Id idTotalTime;
    private final Id idMax;
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final AtomicDouble max = new AtomicDouble();
    private long lastCount = 0L;
    private long lastTotalTime = 0L;

    public SimpleTimer(Id id) {
        this.id = id;
        this.idCount = id.withTag((Tag)Statistic.count);
        this.idTotalTime = id.withTag((Tag)Statistic.totalTime);
        this.idMax = id.withTag((Tag)Statistic.max);
    }

    public void record(long nanoAmount) {
        if (nanoAmount >= 0L) {
            this.totalTime.add(nanoAmount);
            this.count.increment();
            this.max.max((double)nanoAmount);
        }
    }

    private Measurement newMeasurement(Id id, long msNow, Number n) {
        return new Measurement(id, msNow, n.doubleValue());
    }

    @Override
    public void calcMeasurements(long msNow, long secondInterval) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>(3);
        this.calcMeasurements(measurements, msNow, secondInterval);
        this.allMeasurements = measurements;
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        long currentCount = this.count.longValue();
        long currentTotalTime = this.totalTime.longValue();
        measurements.add(this.newMeasurement(this.idCount, msNow, (double)(currentCount - this.lastCount) / (double)secondInterval));
        measurements.add(this.newMeasurement(this.idTotalTime, msNow, (double)((currentTotalTime - this.lastTotalTime) / secondInterval) * CNV_SECONDS));
        measurements.add(this.newMeasurement(this.idMax, msNow, this.max.get() * CNV_SECONDS));
        this.lastCount = currentCount;
        this.lastTotalTime = currentTotalTime;
        this.max.set(0.0);
    }
}

