/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableWell is an enum
type OpcuaNodeIdServicesVariableWell int32

type IOpcuaNodeIdServicesVariableWell interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_ApplicationsExclude                            OpcuaNodeIdServicesVariableWell = 15412
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_EndpointsExclude                               OpcuaNodeIdServicesVariableWell = 15413
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_ApplicationsExclude                    OpcuaNodeIdServicesVariableWell = 15414
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_EndpointsExclude                       OpcuaNodeIdServicesVariableWell = 15415
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_ApplicationsExclude                             OpcuaNodeIdServicesVariableWell = 15416
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_EndpointsExclude                                OpcuaNodeIdServicesVariableWell = 15417
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_ApplicationsExclude                             OpcuaNodeIdServicesVariableWell = 15418
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_EndpointsExclude                                OpcuaNodeIdServicesVariableWell = 15423
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_ApplicationsExclude                             OpcuaNodeIdServicesVariableWell = 15424
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_EndpointsExclude                                OpcuaNodeIdServicesVariableWell = 15425
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_ApplicationsExclude                           OpcuaNodeIdServicesVariableWell = 15426
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_EndpointsExclude                              OpcuaNodeIdServicesVariableWell = 15427
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_ApplicationsExclude                       OpcuaNodeIdServicesVariableWell = 15428
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_EndpointsExclude                          OpcuaNodeIdServicesVariableWell = 15429
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_ApplicationsExclude                        OpcuaNodeIdServicesVariableWell = 15430
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_EndpointsExclude                           OpcuaNodeIdServicesVariableWell = 15527
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddIdentity_InputArguments                     OpcuaNodeIdServicesVariableWell = 15649
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveIdentity_InputArguments                  OpcuaNodeIdServicesVariableWell = 15651
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments             OpcuaNodeIdServicesVariableWell = 15661
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments          OpcuaNodeIdServicesVariableWell = 15663
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddIdentity_InputArguments                      OpcuaNodeIdServicesVariableWell = 15673
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveIdentity_InputArguments                   OpcuaNodeIdServicesVariableWell = 15675
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddIdentity_InputArguments                      OpcuaNodeIdServicesVariableWell = 15685
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveIdentity_InputArguments                   OpcuaNodeIdServicesVariableWell = 15687
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddIdentity_InputArguments                    OpcuaNodeIdServicesVariableWell = 15697
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveIdentity_InputArguments                 OpcuaNodeIdServicesVariableWell = 15699
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments                 OpcuaNodeIdServicesVariableWell = 15709
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments              OpcuaNodeIdServicesVariableWell = 15711
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments                OpcuaNodeIdServicesVariableWell = 15721
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments             OpcuaNodeIdServicesVariableWell = 15723
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddIdentity_InputArguments                      OpcuaNodeIdServicesVariableWell = 16042
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveIdentity_InputArguments                   OpcuaNodeIdServicesVariableWell = 16044
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Identities                                     OpcuaNodeIdServicesVariableWell = 16192
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Applications                                   OpcuaNodeIdServicesVariableWell = 16193
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Endpoints                                      OpcuaNodeIdServicesVariableWell = 16194
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddApplication_InputArguments                  OpcuaNodeIdServicesVariableWell = 16196
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveApplication_InputArguments               OpcuaNodeIdServicesVariableWell = 16198
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddEndpoint_InputArguments                     OpcuaNodeIdServicesVariableWell = 16200
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments                  OpcuaNodeIdServicesVariableWell = 16202
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Identities                             OpcuaNodeIdServicesVariableWell = 16203
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Applications                           OpcuaNodeIdServicesVariableWell = 16204
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Endpoints                              OpcuaNodeIdServicesVariableWell = 16205
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments          OpcuaNodeIdServicesVariableWell = 16207
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments       OpcuaNodeIdServicesVariableWell = 16209
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments             OpcuaNodeIdServicesVariableWell = 16211
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments          OpcuaNodeIdServicesVariableWell = 16213
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Identities                                      OpcuaNodeIdServicesVariableWell = 16214
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Applications                                    OpcuaNodeIdServicesVariableWell = 16215
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Endpoints                                       OpcuaNodeIdServicesVariableWell = 16216
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddApplication_InputArguments                   OpcuaNodeIdServicesVariableWell = 16218
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveApplication_InputArguments                OpcuaNodeIdServicesVariableWell = 16220
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddEndpoint_InputArguments                      OpcuaNodeIdServicesVariableWell = 16222
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveEndpoint_InputArguments                   OpcuaNodeIdServicesVariableWell = 16224
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Identities                                      OpcuaNodeIdServicesVariableWell = 16225
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Applications                                    OpcuaNodeIdServicesVariableWell = 16226
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Endpoints                                       OpcuaNodeIdServicesVariableWell = 16227
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddApplication_InputArguments                   OpcuaNodeIdServicesVariableWell = 16229
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveApplication_InputArguments                OpcuaNodeIdServicesVariableWell = 16231
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddEndpoint_InputArguments                      OpcuaNodeIdServicesVariableWell = 16233
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveEndpoint_InputArguments                   OpcuaNodeIdServicesVariableWell = 16235
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Identities                                      OpcuaNodeIdServicesVariableWell = 16236
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Applications                                    OpcuaNodeIdServicesVariableWell = 16237
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Endpoints                                       OpcuaNodeIdServicesVariableWell = 16238
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddApplication_InputArguments                   OpcuaNodeIdServicesVariableWell = 16240
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveApplication_InputArguments                OpcuaNodeIdServicesVariableWell = 16242
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddEndpoint_InputArguments                      OpcuaNodeIdServicesVariableWell = 16244
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveEndpoint_InputArguments                   OpcuaNodeIdServicesVariableWell = 16246
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Identities                                    OpcuaNodeIdServicesVariableWell = 16247
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Applications                                  OpcuaNodeIdServicesVariableWell = 16248
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Endpoints                                     OpcuaNodeIdServicesVariableWell = 16249
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddApplication_InputArguments                 OpcuaNodeIdServicesVariableWell = 16251
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveApplication_InputArguments              OpcuaNodeIdServicesVariableWell = 16253
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddEndpoint_InputArguments                    OpcuaNodeIdServicesVariableWell = 16255
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments                 OpcuaNodeIdServicesVariableWell = 16257
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Identities                                 OpcuaNodeIdServicesVariableWell = 16258
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Applications                               OpcuaNodeIdServicesVariableWell = 16259
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Endpoints                                  OpcuaNodeIdServicesVariableWell = 16260
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddApplication_InputArguments              OpcuaNodeIdServicesVariableWell = 16262
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments           OpcuaNodeIdServicesVariableWell = 16264
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments                 OpcuaNodeIdServicesVariableWell = 16266
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments              OpcuaNodeIdServicesVariableWell = 16268
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Identities                                OpcuaNodeIdServicesVariableWell = 16269
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Applications                              OpcuaNodeIdServicesVariableWell = 16270
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Endpoints                                 OpcuaNodeIdServicesVariableWell = 16271
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments             OpcuaNodeIdServicesVariableWell = 16273
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments          OpcuaNodeIdServicesVariableWell = 16275
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments                OpcuaNodeIdServicesVariableWell = 16277
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments             OpcuaNodeIdServicesVariableWell = 16279
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Identities                            OpcuaNodeIdServicesVariableWell = 18626
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_ApplicationsExclude                   OpcuaNodeIdServicesVariableWell = 18627
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Applications                          OpcuaNodeIdServicesVariableWell = 18628
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_EndpointsExclude                      OpcuaNodeIdServicesVariableWell = 18629
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Endpoints                             OpcuaNodeIdServicesVariableWell = 18630
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_CustomConfiguration                   OpcuaNodeIdServicesVariableWell = 18631
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddIdentity_InputArguments            OpcuaNodeIdServicesVariableWell = 18633
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments         OpcuaNodeIdServicesVariableWell = 18635
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddApplication_InputArguments         OpcuaNodeIdServicesVariableWell = 18637
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveApplication_InputArguments      OpcuaNodeIdServicesVariableWell = 18639
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddEndpoint_InputArguments            OpcuaNodeIdServicesVariableWell = 18641
	OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments         OpcuaNodeIdServicesVariableWell = 18643
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_CustomConfiguration                            OpcuaNodeIdServicesVariableWell = 24140
	OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_CustomConfiguration                    OpcuaNodeIdServicesVariableWell = 24141
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_CustomConfiguration                             OpcuaNodeIdServicesVariableWell = 24142
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_CustomConfiguration                             OpcuaNodeIdServicesVariableWell = 24143
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_CustomConfiguration                             OpcuaNodeIdServicesVariableWell = 24144
	OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_CustomConfiguration                           OpcuaNodeIdServicesVariableWell = 24145
	OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_CustomConfiguration                       OpcuaNodeIdServicesVariableWell = 24146
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_CustomConfiguration                        OpcuaNodeIdServicesVariableWell = 24147
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Identities                        OpcuaNodeIdServicesVariableWell = 25566
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude               OpcuaNodeIdServicesVariableWell = 25567
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Applications                      OpcuaNodeIdServicesVariableWell = 25568
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude                  OpcuaNodeIdServicesVariableWell = 25569
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Endpoints                         OpcuaNodeIdServicesVariableWell = 25570
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration               OpcuaNodeIdServicesVariableWell = 25571
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments        OpcuaNodeIdServicesVariableWell = 25573
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments     OpcuaNodeIdServicesVariableWell = 25575
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments     OpcuaNodeIdServicesVariableWell = 25577
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments  OpcuaNodeIdServicesVariableWell = 25579
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments        OpcuaNodeIdServicesVariableWell = 25581
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments     OpcuaNodeIdServicesVariableWell = 25583
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Identities                         OpcuaNodeIdServicesVariableWell = 25585
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude                OpcuaNodeIdServicesVariableWell = 25586
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Applications                       OpcuaNodeIdServicesVariableWell = 25587
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_EndpointsExclude                   OpcuaNodeIdServicesVariableWell = 25588
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Endpoints                          OpcuaNodeIdServicesVariableWell = 25589
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_CustomConfiguration                OpcuaNodeIdServicesVariableWell = 25590
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments         OpcuaNodeIdServicesVariableWell = 25592
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments      OpcuaNodeIdServicesVariableWell = 25594
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments      OpcuaNodeIdServicesVariableWell = 25596
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments   OpcuaNodeIdServicesVariableWell = 25598
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments         OpcuaNodeIdServicesVariableWell = 25600
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments      OpcuaNodeIdServicesVariableWell = 25602
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Identities                       OpcuaNodeIdServicesVariableWell = 25604
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude              OpcuaNodeIdServicesVariableWell = 25605
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Applications                     OpcuaNodeIdServicesVariableWell = 25606
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude                 OpcuaNodeIdServicesVariableWell = 25607
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Endpoints                        OpcuaNodeIdServicesVariableWell = 25608
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration              OpcuaNodeIdServicesVariableWell = 25609
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments       OpcuaNodeIdServicesVariableWell = 25611
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments    OpcuaNodeIdServicesVariableWell = 25613
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments    OpcuaNodeIdServicesVariableWell = 25615
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments OpcuaNodeIdServicesVariableWell = 25617
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments       OpcuaNodeIdServicesVariableWell = 25619
	OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments    OpcuaNodeIdServicesVariableWell = 25621
)

var OpcuaNodeIdServicesVariableWellValues []OpcuaNodeIdServicesVariableWell

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableWellValues = []OpcuaNodeIdServicesVariableWell{
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Identities,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Applications,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Endpoints,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments,
		OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments,
	}
}

func OpcuaNodeIdServicesVariableWellByValue(value int32) (enum OpcuaNodeIdServicesVariableWell, ok bool) {
	switch value {
	case 15412:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_ApplicationsExclude, true
	case 15413:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_EndpointsExclude, true
	case 15414:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_ApplicationsExclude, true
	case 15415:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_EndpointsExclude, true
	case 15416:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_ApplicationsExclude, true
	case 15417:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_EndpointsExclude, true
	case 15418:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_ApplicationsExclude, true
	case 15423:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_EndpointsExclude, true
	case 15424:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_ApplicationsExclude, true
	case 15425:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_EndpointsExclude, true
	case 15426:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_ApplicationsExclude, true
	case 15427:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_EndpointsExclude, true
	case 15428:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_ApplicationsExclude, true
	case 15429:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_EndpointsExclude, true
	case 15430:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_ApplicationsExclude, true
	case 15527:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_EndpointsExclude, true
	case 15649:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddIdentity_InputArguments, true
	case 15651:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveIdentity_InputArguments, true
	case 15661:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments, true
	case 15663:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments, true
	case 15673:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddIdentity_InputArguments, true
	case 15675:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveIdentity_InputArguments, true
	case 15685:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddIdentity_InputArguments, true
	case 15687:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveIdentity_InputArguments, true
	case 15697:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddIdentity_InputArguments, true
	case 15699:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveIdentity_InputArguments, true
	case 15709:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments, true
	case 15711:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments, true
	case 15721:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments, true
	case 15723:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments, true
	case 16042:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddIdentity_InputArguments, true
	case 16044:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveIdentity_InputArguments, true
	case 16192:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Identities, true
	case 16193:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Applications, true
	case 16194:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Endpoints, true
	case 16196:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddApplication_InputArguments, true
	case 16198:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveApplication_InputArguments, true
	case 16200:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddEndpoint_InputArguments, true
	case 16202:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments, true
	case 16203:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Identities, true
	case 16204:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Applications, true
	case 16205:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Endpoints, true
	case 16207:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments, true
	case 16209:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments, true
	case 16211:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments, true
	case 16213:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments, true
	case 16214:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Identities, true
	case 16215:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Applications, true
	case 16216:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Endpoints, true
	case 16218:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddApplication_InputArguments, true
	case 16220:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveApplication_InputArguments, true
	case 16222:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddEndpoint_InputArguments, true
	case 16224:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveEndpoint_InputArguments, true
	case 16225:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Identities, true
	case 16226:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Applications, true
	case 16227:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Endpoints, true
	case 16229:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddApplication_InputArguments, true
	case 16231:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveApplication_InputArguments, true
	case 16233:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddEndpoint_InputArguments, true
	case 16235:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveEndpoint_InputArguments, true
	case 16236:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Identities, true
	case 16237:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Applications, true
	case 16238:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Endpoints, true
	case 16240:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddApplication_InputArguments, true
	case 16242:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveApplication_InputArguments, true
	case 16244:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddEndpoint_InputArguments, true
	case 16246:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveEndpoint_InputArguments, true
	case 16247:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Identities, true
	case 16248:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Applications, true
	case 16249:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Endpoints, true
	case 16251:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddApplication_InputArguments, true
	case 16253:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveApplication_InputArguments, true
	case 16255:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddEndpoint_InputArguments, true
	case 16257:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments, true
	case 16258:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Identities, true
	case 16259:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Applications, true
	case 16260:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Endpoints, true
	case 16262:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddApplication_InputArguments, true
	case 16264:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments, true
	case 16266:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments, true
	case 16268:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments, true
	case 16269:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Identities, true
	case 16270:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Applications, true
	case 16271:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Endpoints, true
	case 16273:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments, true
	case 16275:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments, true
	case 16277:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments, true
	case 16279:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments, true
	case 18626:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Identities, true
	case 18627:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_ApplicationsExclude, true
	case 18628:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Applications, true
	case 18629:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_EndpointsExclude, true
	case 18630:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Endpoints, true
	case 18631:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_CustomConfiguration, true
	case 18633:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddIdentity_InputArguments, true
	case 18635:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments, true
	case 18637:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddApplication_InputArguments, true
	case 18639:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveApplication_InputArguments, true
	case 18641:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddEndpoint_InputArguments, true
	case 18643:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments, true
	case 24140:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_CustomConfiguration, true
	case 24141:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_CustomConfiguration, true
	case 24142:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_CustomConfiguration, true
	case 24143:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_CustomConfiguration, true
	case 24144:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_CustomConfiguration, true
	case 24145:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_CustomConfiguration, true
	case 24146:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_CustomConfiguration, true
	case 24147:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_CustomConfiguration, true
	case 25566:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Identities, true
	case 25567:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude, true
	case 25568:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Applications, true
	case 25569:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude, true
	case 25570:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Endpoints, true
	case 25571:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration, true
	case 25573:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments, true
	case 25575:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments, true
	case 25577:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments, true
	case 25579:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments, true
	case 25581:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments, true
	case 25583:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments, true
	case 25585:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Identities, true
	case 25586:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude, true
	case 25587:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Applications, true
	case 25588:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_EndpointsExclude, true
	case 25589:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Endpoints, true
	case 25590:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_CustomConfiguration, true
	case 25592:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments, true
	case 25594:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments, true
	case 25596:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments, true
	case 25598:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments, true
	case 25600:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments, true
	case 25602:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments, true
	case 25604:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Identities, true
	case 25605:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude, true
	case 25606:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Applications, true
	case 25607:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude, true
	case 25608:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Endpoints, true
	case 25609:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration, true
	case 25611:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments, true
	case 25613:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments, true
	case 25615:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments, true
	case 25617:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments, true
	case 25619:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments, true
	case 25621:
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableWellByName(value string) (enum OpcuaNodeIdServicesVariableWell, ok bool) {
	switch value {
	case "WellKnownRole_Anonymous_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_ApplicationsExclude, true
	case "WellKnownRole_Anonymous_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_EndpointsExclude, true
	case "WellKnownRole_AuthenticatedUser_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_ApplicationsExclude, true
	case "WellKnownRole_AuthenticatedUser_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_EndpointsExclude, true
	case "WellKnownRole_Observer_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_ApplicationsExclude, true
	case "WellKnownRole_Observer_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_EndpointsExclude, true
	case "WellKnownRole_Operator_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_ApplicationsExclude, true
	case "WellKnownRole_Operator_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_EndpointsExclude, true
	case "WellKnownRole_Engineer_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_ApplicationsExclude, true
	case "WellKnownRole_Engineer_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_EndpointsExclude, true
	case "WellKnownRole_Supervisor_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_ApplicationsExclude, true
	case "WellKnownRole_Supervisor_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_EndpointsExclude, true
	case "WellKnownRole_ConfigureAdmin_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_ApplicationsExclude, true
	case "WellKnownRole_ConfigureAdmin_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_EndpointsExclude, true
	case "WellKnownRole_SecurityAdmin_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_ApplicationsExclude, true
	case "WellKnownRole_SecurityAdmin_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_EndpointsExclude, true
	case "WellKnownRole_Anonymous_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddIdentity_InputArguments, true
	case "WellKnownRole_Anonymous_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveIdentity_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments, true
	case "WellKnownRole_Observer_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddIdentity_InputArguments, true
	case "WellKnownRole_Observer_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveIdentity_InputArguments, true
	case "WellKnownRole_Operator_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddIdentity_InputArguments, true
	case "WellKnownRole_Operator_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveIdentity_InputArguments, true
	case "WellKnownRole_Supervisor_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddIdentity_InputArguments, true
	case "WellKnownRole_Supervisor_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveIdentity_InputArguments, true
	case "WellKnownRole_SecurityAdmin_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments, true
	case "WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments, true
	case "WellKnownRole_Engineer_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddIdentity_InputArguments, true
	case "WellKnownRole_Engineer_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveIdentity_InputArguments, true
	case "WellKnownRole_Anonymous_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Identities, true
	case "WellKnownRole_Anonymous_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Applications, true
	case "WellKnownRole_Anonymous_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Endpoints, true
	case "WellKnownRole_Anonymous_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddApplication_InputArguments, true
	case "WellKnownRole_Anonymous_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveApplication_InputArguments, true
	case "WellKnownRole_Anonymous_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddEndpoint_InputArguments, true
	case "WellKnownRole_Anonymous_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Identities, true
	case "WellKnownRole_AuthenticatedUser_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Applications, true
	case "WellKnownRole_AuthenticatedUser_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Endpoints, true
	case "WellKnownRole_AuthenticatedUser_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments, true
	case "WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_Observer_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Identities, true
	case "WellKnownRole_Observer_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Applications, true
	case "WellKnownRole_Observer_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Endpoints, true
	case "WellKnownRole_Observer_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddApplication_InputArguments, true
	case "WellKnownRole_Observer_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveApplication_InputArguments, true
	case "WellKnownRole_Observer_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddEndpoint_InputArguments, true
	case "WellKnownRole_Observer_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_Operator_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Identities, true
	case "WellKnownRole_Operator_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Applications, true
	case "WellKnownRole_Operator_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Endpoints, true
	case "WellKnownRole_Operator_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddApplication_InputArguments, true
	case "WellKnownRole_Operator_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveApplication_InputArguments, true
	case "WellKnownRole_Operator_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddEndpoint_InputArguments, true
	case "WellKnownRole_Operator_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_Engineer_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Identities, true
	case "WellKnownRole_Engineer_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Applications, true
	case "WellKnownRole_Engineer_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Endpoints, true
	case "WellKnownRole_Engineer_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddApplication_InputArguments, true
	case "WellKnownRole_Engineer_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveApplication_InputArguments, true
	case "WellKnownRole_Engineer_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddEndpoint_InputArguments, true
	case "WellKnownRole_Engineer_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_Supervisor_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Identities, true
	case "WellKnownRole_Supervisor_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Applications, true
	case "WellKnownRole_Supervisor_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Endpoints, true
	case "WellKnownRole_Supervisor_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddApplication_InputArguments, true
	case "WellKnownRole_Supervisor_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveApplication_InputArguments, true
	case "WellKnownRole_Supervisor_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddEndpoint_InputArguments, true
	case "WellKnownRole_Supervisor_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_SecurityAdmin_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Identities, true
	case "WellKnownRole_SecurityAdmin_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Applications, true
	case "WellKnownRole_SecurityAdmin_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Endpoints, true
	case "WellKnownRole_SecurityAdmin_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddApplication_InputArguments, true
	case "WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments, true
	case "WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments, true
	case "WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Identities, true
	case "WellKnownRole_ConfigureAdmin_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Applications, true
	case "WellKnownRole_ConfigureAdmin_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Endpoints, true
	case "WellKnownRole_ConfigureAdmin_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments, true
	case "WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_TrustedApplication_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Identities, true
	case "WellKnownRole_TrustedApplication_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_ApplicationsExclude, true
	case "WellKnownRole_TrustedApplication_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Applications, true
	case "WellKnownRole_TrustedApplication_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_EndpointsExclude, true
	case "WellKnownRole_TrustedApplication_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Endpoints, true
	case "WellKnownRole_TrustedApplication_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_CustomConfiguration, true
	case "WellKnownRole_TrustedApplication_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddIdentity_InputArguments, true
	case "WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments, true
	case "WellKnownRole_TrustedApplication_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddApplication_InputArguments, true
	case "WellKnownRole_TrustedApplication_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveApplication_InputArguments, true
	case "WellKnownRole_TrustedApplication_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddEndpoint_InputArguments, true
	case "WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_Anonymous_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_CustomConfiguration, true
	case "WellKnownRole_AuthenticatedUser_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_CustomConfiguration, true
	case "WellKnownRole_Observer_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_CustomConfiguration, true
	case "WellKnownRole_Operator_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_CustomConfiguration, true
	case "WellKnownRole_Engineer_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_CustomConfiguration, true
	case "WellKnownRole_Supervisor_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_CustomConfiguration, true
	case "WellKnownRole_ConfigureAdmin_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_CustomConfiguration, true
	case "WellKnownRole_SecurityAdmin_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_CustomConfiguration, true
	case "WellKnownRole_SecurityKeyServerAdmin_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Identities, true
	case "WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude, true
	case "WellKnownRole_SecurityKeyServerAdmin_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Applications, true
	case "WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude, true
	case "WellKnownRole_SecurityKeyServerAdmin_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Endpoints, true
	case "WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Identities, true
	case "WellKnownRole_SecurityKeyServerPush_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude, true
	case "WellKnownRole_SecurityKeyServerPush_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Applications, true
	case "WellKnownRole_SecurityKeyServerPush_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_EndpointsExclude, true
	case "WellKnownRole_SecurityKeyServerPush_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Endpoints, true
	case "WellKnownRole_SecurityKeyServerPush_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_CustomConfiguration, true
	case "WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments, true
	case "WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_Identities":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Identities, true
	case "WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude, true
	case "WellKnownRole_SecurityKeyServerAccess_Applications":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Applications, true
	case "WellKnownRole_SecurityKeyServerAccess_EndpointsExclude":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude, true
	case "WellKnownRole_SecurityKeyServerAccess_Endpoints":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Endpoints, true
	case "WellKnownRole_SecurityKeyServerAccess_CustomConfiguration":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration, true
	case "WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments, true
	case "WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments":
		return OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableWellKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableWellValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableWell(structType any) OpcuaNodeIdServicesVariableWell {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableWell {
		if sOpcuaNodeIdServicesVariableWell, ok := typ.(OpcuaNodeIdServicesVariableWell); ok {
			return sOpcuaNodeIdServicesVariableWell
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableWell) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableWell) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableWellParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableWell, error) {
	return OpcuaNodeIdServicesVariableWellParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableWellParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableWell, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableWell", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableWell")
	}
	if enum, ok := OpcuaNodeIdServicesVariableWellByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableWell")
		return OpcuaNodeIdServicesVariableWell(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableWell) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableWell) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableWell", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableWell) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableWell) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_ApplicationsExclude:
		return "WellKnownRole_Anonymous_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_EndpointsExclude:
		return "WellKnownRole_Anonymous_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_ApplicationsExclude:
		return "WellKnownRole_AuthenticatedUser_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_EndpointsExclude:
		return "WellKnownRole_AuthenticatedUser_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_ApplicationsExclude:
		return "WellKnownRole_Observer_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_EndpointsExclude:
		return "WellKnownRole_Observer_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_ApplicationsExclude:
		return "WellKnownRole_Operator_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_EndpointsExclude:
		return "WellKnownRole_Operator_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_ApplicationsExclude:
		return "WellKnownRole_Engineer_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_EndpointsExclude:
		return "WellKnownRole_Engineer_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_ApplicationsExclude:
		return "WellKnownRole_Supervisor_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_EndpointsExclude:
		return "WellKnownRole_Supervisor_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_ApplicationsExclude:
		return "WellKnownRole_ConfigureAdmin_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_EndpointsExclude:
		return "WellKnownRole_ConfigureAdmin_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_ApplicationsExclude:
		return "WellKnownRole_SecurityAdmin_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_EndpointsExclude:
		return "WellKnownRole_SecurityAdmin_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddIdentity_InputArguments:
		return "WellKnownRole_Anonymous_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveIdentity_InputArguments:
		return "WellKnownRole_Anonymous_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments:
		return "WellKnownRole_AuthenticatedUser_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments:
		return "WellKnownRole_AuthenticatedUser_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddIdentity_InputArguments:
		return "WellKnownRole_Observer_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveIdentity_InputArguments:
		return "WellKnownRole_Observer_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddIdentity_InputArguments:
		return "WellKnownRole_Operator_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveIdentity_InputArguments:
		return "WellKnownRole_Operator_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddIdentity_InputArguments:
		return "WellKnownRole_Supervisor_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveIdentity_InputArguments:
		return "WellKnownRole_Supervisor_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddIdentity_InputArguments:
		return "WellKnownRole_SecurityAdmin_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments:
		return "WellKnownRole_SecurityAdmin_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments:
		return "WellKnownRole_ConfigureAdmin_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments:
		return "WellKnownRole_ConfigureAdmin_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddIdentity_InputArguments:
		return "WellKnownRole_Engineer_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveIdentity_InputArguments:
		return "WellKnownRole_Engineer_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Identities:
		return "WellKnownRole_Anonymous_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Applications:
		return "WellKnownRole_Anonymous_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_Endpoints:
		return "WellKnownRole_Anonymous_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddApplication_InputArguments:
		return "WellKnownRole_Anonymous_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveApplication_InputArguments:
		return "WellKnownRole_Anonymous_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_AddEndpoint_InputArguments:
		return "WellKnownRole_Anonymous_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_RemoveEndpoint_InputArguments:
		return "WellKnownRole_Anonymous_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Identities:
		return "WellKnownRole_AuthenticatedUser_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Applications:
		return "WellKnownRole_AuthenticatedUser_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_Endpoints:
		return "WellKnownRole_AuthenticatedUser_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddApplication_InputArguments:
		return "WellKnownRole_AuthenticatedUser_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments:
		return "WellKnownRole_AuthenticatedUser_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments:
		return "WellKnownRole_AuthenticatedUser_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments:
		return "WellKnownRole_AuthenticatedUser_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Identities:
		return "WellKnownRole_Observer_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Applications:
		return "WellKnownRole_Observer_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_Endpoints:
		return "WellKnownRole_Observer_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddApplication_InputArguments:
		return "WellKnownRole_Observer_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveApplication_InputArguments:
		return "WellKnownRole_Observer_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_AddEndpoint_InputArguments:
		return "WellKnownRole_Observer_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_RemoveEndpoint_InputArguments:
		return "WellKnownRole_Observer_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Identities:
		return "WellKnownRole_Operator_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Applications:
		return "WellKnownRole_Operator_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_Endpoints:
		return "WellKnownRole_Operator_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddApplication_InputArguments:
		return "WellKnownRole_Operator_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveApplication_InputArguments:
		return "WellKnownRole_Operator_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_AddEndpoint_InputArguments:
		return "WellKnownRole_Operator_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_RemoveEndpoint_InputArguments:
		return "WellKnownRole_Operator_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Identities:
		return "WellKnownRole_Engineer_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Applications:
		return "WellKnownRole_Engineer_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_Endpoints:
		return "WellKnownRole_Engineer_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddApplication_InputArguments:
		return "WellKnownRole_Engineer_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveApplication_InputArguments:
		return "WellKnownRole_Engineer_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_AddEndpoint_InputArguments:
		return "WellKnownRole_Engineer_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_RemoveEndpoint_InputArguments:
		return "WellKnownRole_Engineer_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Identities:
		return "WellKnownRole_Supervisor_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Applications:
		return "WellKnownRole_Supervisor_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_Endpoints:
		return "WellKnownRole_Supervisor_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddApplication_InputArguments:
		return "WellKnownRole_Supervisor_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveApplication_InputArguments:
		return "WellKnownRole_Supervisor_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_AddEndpoint_InputArguments:
		return "WellKnownRole_Supervisor_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_RemoveEndpoint_InputArguments:
		return "WellKnownRole_Supervisor_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Identities:
		return "WellKnownRole_SecurityAdmin_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Applications:
		return "WellKnownRole_SecurityAdmin_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_Endpoints:
		return "WellKnownRole_SecurityAdmin_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddApplication_InputArguments:
		return "WellKnownRole_SecurityAdmin_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments:
		return "WellKnownRole_SecurityAdmin_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments:
		return "WellKnownRole_SecurityAdmin_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments:
		return "WellKnownRole_SecurityAdmin_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Identities:
		return "WellKnownRole_ConfigureAdmin_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Applications:
		return "WellKnownRole_ConfigureAdmin_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_Endpoints:
		return "WellKnownRole_ConfigureAdmin_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddApplication_InputArguments:
		return "WellKnownRole_ConfigureAdmin_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments:
		return "WellKnownRole_ConfigureAdmin_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments:
		return "WellKnownRole_ConfigureAdmin_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments:
		return "WellKnownRole_ConfigureAdmin_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Identities:
		return "WellKnownRole_TrustedApplication_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_ApplicationsExclude:
		return "WellKnownRole_TrustedApplication_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Applications:
		return "WellKnownRole_TrustedApplication_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_EndpointsExclude:
		return "WellKnownRole_TrustedApplication_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_Endpoints:
		return "WellKnownRole_TrustedApplication_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_CustomConfiguration:
		return "WellKnownRole_TrustedApplication_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddIdentity_InputArguments:
		return "WellKnownRole_TrustedApplication_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments:
		return "WellKnownRole_TrustedApplication_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddApplication_InputArguments:
		return "WellKnownRole_TrustedApplication_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveApplication_InputArguments:
		return "WellKnownRole_TrustedApplication_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_AddEndpoint_InputArguments:
		return "WellKnownRole_TrustedApplication_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments:
		return "WellKnownRole_TrustedApplication_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Anonymous_CustomConfiguration:
		return "WellKnownRole_Anonymous_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_AuthenticatedUser_CustomConfiguration:
		return "WellKnownRole_AuthenticatedUser_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Observer_CustomConfiguration:
		return "WellKnownRole_Observer_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Operator_CustomConfiguration:
		return "WellKnownRole_Operator_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Engineer_CustomConfiguration:
		return "WellKnownRole_Engineer_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_Supervisor_CustomConfiguration:
		return "WellKnownRole_Supervisor_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_ConfigureAdmin_CustomConfiguration:
		return "WellKnownRole_ConfigureAdmin_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityAdmin_CustomConfiguration:
		return "WellKnownRole_SecurityAdmin_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Identities:
		return "WellKnownRole_SecurityKeyServerAdmin_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude:
		return "WellKnownRole_SecurityKeyServerAdmin_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Applications:
		return "WellKnownRole_SecurityKeyServerAdmin_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude:
		return "WellKnownRole_SecurityKeyServerAdmin_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_Endpoints:
		return "WellKnownRole_SecurityKeyServerAdmin_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration:
		return "WellKnownRole_SecurityKeyServerAdmin_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Identities:
		return "WellKnownRole_SecurityKeyServerPush_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_ApplicationsExclude:
		return "WellKnownRole_SecurityKeyServerPush_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Applications:
		return "WellKnownRole_SecurityKeyServerPush_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_EndpointsExclude:
		return "WellKnownRole_SecurityKeyServerPush_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_Endpoints:
		return "WellKnownRole_SecurityKeyServerPush_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_CustomConfiguration:
		return "WellKnownRole_SecurityKeyServerPush_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerPush_RemoveEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Identities:
		return "WellKnownRole_SecurityKeyServerAccess_Identities"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude:
		return "WellKnownRole_SecurityKeyServerAccess_ApplicationsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Applications:
		return "WellKnownRole_SecurityKeyServerAccess_Applications"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_EndpointsExclude:
		return "WellKnownRole_SecurityKeyServerAccess_EndpointsExclude"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_Endpoints:
		return "WellKnownRole_SecurityKeyServerAccess_Endpoints"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_CustomConfiguration:
		return "WellKnownRole_SecurityKeyServerAccess_CustomConfiguration"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_AddIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_RemoveIdentity_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_AddApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_RemoveApplication_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_AddEndpoint_InputArguments"
	case OpcuaNodeIdServicesVariableWell_WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments:
		return "WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint_InputArguments"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableWell) String() string {
	return e.PLC4XEnumName()
}
