/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.configuration.SystemProperty;

public class ProcessHandleManagementServerAddressProvider
implements ManagementServerAddressProvider {
    private static final Pattern ADDRESS_ARGUMENT_PATTERN = Pattern.compile("^-D%s=(.+?)$".formatted(SystemProperty.MANAGEMENT_SERVER_ADDRESS.getProperty()));
    private static final int ADDRESS_GROUP = 1;
    private final ProcessHandle processHandle;

    public ProcessHandleManagementServerAddressProvider(ProcessHandle processHandle) {
        this.processHandle = Objects.requireNonNull(processHandle);
    }

    @Override
    public Optional<String> getAddress() {
        String managementServerAddress;
        ProcessHandle.Info info = this.processHandle.info();
        Optional<String[]> argumentsFound = info.arguments();
        if (argumentsFound.isPresent()) {
            String[] arguments = argumentsFound.get();
            managementServerAddress = this.findManagementServerAddress(arguments);
        } else {
            managementServerAddress = null;
        }
        return Optional.ofNullable(managementServerAddress);
    }

    private String findManagementServerAddress(String[] arguments) {
        String managementServerAddress = null;
        for (String argument : arguments) {
            Matcher matcher = ADDRESS_ARGUMENT_PATTERN.matcher(argument);
            if (!matcher.matches()) continue;
            managementServerAddress = matcher.group(1);
            break;
        }
        return managementServerAddress;
    }
}

