/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.context;

import io.micrometer.context.ThreadLocalAccessor;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class ReactiveSecurityContextHolderThreadLocalAccessor
implements ThreadLocalAccessor<Mono<SecurityContext>> {
    private static final ThreadLocal<Mono<SecurityContext>> threadLocal = new ThreadLocal();

    public Object key() {
        return SecurityContext.class;
    }

    public Mono<SecurityContext> getValue() {
        return threadLocal.get();
    }

    public void setValue(Mono<SecurityContext> securityContext) {
        Assert.notNull(securityContext, (String)"securityContext cannot be null");
        threadLocal.set(securityContext);
    }

    public void setValue() {
        threadLocal.remove();
    }
}

