/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.ui;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public final class DefaultResourcesWebFilter
implements WebFilter {
    private final ServerWebExchangeMatcher matcher;
    private final ClassPathResource resource;
    private final MediaType mediaType;

    private DefaultResourcesWebFilter(ServerWebExchangeMatcher matcher, ClassPathResource resource, MediaType mediaType) {
        Assert.isTrue((boolean)resource.exists(), (String)"classpath resource must exist");
        this.matcher = matcher;
        this.resource = resource;
        this.mediaType = mediaType;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> this.sendContent(exchange));
    }

    private Mono<Void> sendContent(ServerWebExchange exchange) {
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.OK);
        ResourceHttpMessageWriter writer = new ResourceHttpMessageWriter();
        return writer.write((Publisher)Mono.just((Object)this.resource), ResolvableType.forClass(Resource.class), ResolvableType.forClass(Resource.class), this.mediaType, exchange.getRequest(), exchange.getResponse(), Collections.emptyMap());
    }

    public String toString() {
        return "%s{matcher=%s, resource='%s'}".formatted(this.getClass().getSimpleName(), this.matcher, this.resource.getPath());
    }

    public static DefaultResourcesWebFilter css() {
        return new DefaultResourcesWebFilter(new PathPatternParserServerWebExchangeMatcher("/default-ui.css", HttpMethod.GET), new ClassPathResource("org/springframework/security/default-ui.css"), new MediaType("text", "css", StandardCharsets.UTF_8));
    }
}

