/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.model;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class WrapperList<T, U>
extends AbstractList<T>
implements Serializable {
    private final Supplier<List<U>> getter;
    private final Consumer<List<U>> setter;
    private final Function<U, T> mapper;
    private final Function<T, U> revMapper;

    WrapperList(List<U> list, Function<U, T> mapper, Function<T, U> revMapper) {
        this(() -> list, null, mapper, revMapper);
    }

    WrapperList(Supplier<List<U>> getter, Consumer<List<U>> setter, Function<U, T> mapper, Function<T, U> revMapper) {
        this.getter = getter;
        this.setter = setter;
        this.mapper = mapper;
        this.revMapper = revMapper;
    }

    @Override
    public T get(int index) {
        return this.mapper.apply(this.getter.get().get(index));
    }

    @Override
    public int size() {
        return this.getter.get().size();
    }

    @Override
    public boolean add(T t) {
        Objects.requireNonNull(t);
        if (this.setter != null) {
            ArrayList<U> list = new ArrayList<U>((Collection)this.getter.get());
            boolean ret = list.add(this.revMapper.apply(t));
            this.setter.accept(list);
            return ret;
        }
        return this.getter.get().add(this.revMapper.apply(t));
    }

    @Override
    public T set(int index, T element) {
        Objects.requireNonNull(element);
        if (this.setter != null) {
            ArrayList<U> list = new ArrayList<U>((Collection)this.getter.get());
            U ret = list.set(index, this.revMapper.apply(element));
            this.setter.accept(list);
            return this.mapper.apply(ret);
        }
        return this.mapper.apply(this.getter.get().set(index, this.revMapper.apply(element)));
    }

    @Override
    public void add(int index, T element) {
        Objects.requireNonNull(element);
        if (this.setter != null) {
            ArrayList<U> list = new ArrayList<U>((Collection)this.getter.get());
            list.add(index, this.revMapper.apply(element));
            this.setter.accept(list);
        } else {
            this.getter.get().add(index, this.revMapper.apply(element));
        }
    }

    @Override
    public T remove(int index) {
        if (this.setter != null) {
            ArrayList list = new ArrayList(this.getter.get());
            Object ret = list.remove(index);
            this.setter.accept(list);
            return this.mapper.apply(ret);
        }
        return this.mapper.apply(this.getter.get().remove(index));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ArrayList(this);
    }
}

