/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.impala;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;
import org.apache.knox.gateway.impala.ImpalaDispatchUtils;

public class ImpalaHaDispatch
extends DefaultHaDispatch {
    private boolean basicAuthPreemptive;

    public ImpalaHaDispatch() {
        this.setServiceRole("IMPALA");
    }

    protected void addCredentialsToRequest(HttpUriRequest request) {
        if (this.isBasicAuthPreemptive()) {
            ImpalaDispatchUtils.addCredentialsToRequest(request);
        }
    }

    @Configure
    public void setBasicAuthPreemptive(@Default(value="false") boolean basicAuthPreemptive) {
        this.basicAuthPreemptive = basicAuthPreemptive;
    }

    public boolean isBasicAuthPreemptive() {
        return this.basicAuthPreemptive;
    }
}

