/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.DeploymentFactory;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;

public class DeploymentContextImpl
implements DeploymentContext {
    private GatewayConfig gatewayConfig;
    private Topology topology;
    private GatewayDescriptor gatewayDescriptor;
    private WebArchive webArchive;
    private WebAppDescriptor webAppDescriptor;
    Map<String, List<ProviderDeploymentContributor>> providers;
    private Map<String, Object> descriptors;

    public DeploymentContextImpl(GatewayConfig gatewayConfig, Topology topology, GatewayDescriptor gatewayDescriptor, WebArchive webArchive, WebAppDescriptor webAppDescriptor, Map<String, List<ProviderDeploymentContributor>> providers) {
        this.gatewayConfig = gatewayConfig;
        this.topology = topology;
        this.gatewayDescriptor = gatewayDescriptor;
        this.webArchive = webArchive;
        this.webAppDescriptor = webAppDescriptor;
        this.providers = providers;
        this.descriptors = new HashMap<String, Object>();
    }

    public GatewayConfig getGatewayConfig() {
        return this.gatewayConfig;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public WebArchive getWebArchive() {
        return this.webArchive;
    }

    public WebAppDescriptor getWebAppDescriptor() {
        return this.webAppDescriptor;
    }

    public GatewayDescriptor getGatewayDescriptor() {
        return this.gatewayDescriptor;
    }

    public void contributeFilter(Service service, ResourceDescriptor resource, String role, String name, List<FilterParamDescriptor> params) {
        ProviderDeploymentContributor contributor = DeploymentFactory.getProviderContributor(this.providers, role, name);
        Provider provider = this.getTopology().getProvider(role, name);
        if (provider == null) {
            provider = new Provider();
            provider.setRole(role);
            provider.setName(name);
            provider.setEnabled(true);
        }
        if (provider.isEnabled()) {
            contributor.contributeFilter((DeploymentContext)this, provider, service, resource, params);
        }
    }

    public void addDescriptor(String name, Object descriptor) {
        this.descriptors.put(name, descriptor);
    }

    public <T> T getDescriptor(String name) {
        return (T)this.descriptors.get(name);
    }
}

