/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.integrations.shiro;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.integrations.shiro.EhcacheShiro;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheShiroManager
implements org.apache.shiro.cache.CacheManager,
Initializable,
Destroyable {
    private static final Logger log = LoggerFactory.getLogger(EhcacheShiroManager.class);
    private volatile CacheManager manager;
    private volatile String cacheManagerConfigFile = "classpath:/org/ehcache/integrations/shiro/ehcache.xml";
    private volatile boolean cacheManagerImplicitlyCreated = false;
    private volatile XmlConfiguration cacheConfiguration = null;

    public CacheManager getCacheManager() {
        return this.manager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        try {
            this.destroy();
        }
        catch (Exception e) {
            log.warn("The Shiro managed CacheManager threw an Exception while closing", (Throwable)e);
        }
        this.manager = cacheManager;
        this.cacheManagerImplicitlyCreated = false;
    }

    public String getCacheManagerConfigFile() {
        return this.cacheManagerConfigFile;
    }

    public void setCacheManagerConfigFile(String cacheManagerConfigFile) {
        this.cacheManagerConfigFile = cacheManagerConfigFile;
    }

    public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String name) throws CacheException {
        log.trace("Acquiring EhcacheShiro instance named [{}]", (Object)name);
        try {
            Cache<Object, Object> cache = this.ensureCacheManager().getCache(name, Object.class, Object.class);
            if (cache == null) {
                log.info("Cache with name {} does not yet exist.  Creating now.", (Object)name);
                cache = this.createCache(name);
                log.info("Added EhcacheShiro named [{}]", (Object)name);
            } else {
                log.info("Using existing EhcacheShiro named [{}]", (Object)name);
            }
            return new EhcacheShiro(cache);
        }
        catch (MalformedURLException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Cache<Object, Object> createCache(String name) {
        try {
            XmlConfiguration xmlConfiguration = this.getConfiguration();
            CacheConfigurationBuilder configurationBuilder = xmlConfiguration.newCacheConfigurationBuilderFromTemplate("defaultCacheConfiguration", Object.class, Object.class);
            CacheConfiguration cacheConfiguration = configurationBuilder.build();
            return this.ensureCacheManager().createCache(name, cacheConfiguration);
        }
        catch (InstantiationException e) {
            throw new CacheException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private CacheManager ensureCacheManager() throws MalformedURLException {
        if (this.manager == null) {
            this.manager = CacheManagerBuilder.newCacheManager((Configuration)this.getConfiguration());
            this.manager.init();
            this.cacheManagerImplicitlyCreated = true;
        }
        return this.manager;
    }

    private URL getResource() throws MalformedURLException {
        String cacheManagerConfigFile = this.getCacheManagerConfigFile();
        if (cacheManagerConfigFile.startsWith("classpath:")) {
            return EhcacheShiroManager.class.getClass().getResource(EhcacheShiroManager.stripPrefix(cacheManagerConfigFile));
        }
        String url = ResourceUtils.hasResourcePrefix((String)cacheManagerConfigFile) ? EhcacheShiroManager.stripPrefix(cacheManagerConfigFile) : cacheManagerConfigFile;
        return new URL(url);
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    private XmlConfiguration getConfiguration() throws MalformedURLException {
        if (this.cacheConfiguration == null) {
            this.cacheConfiguration = new XmlConfiguration(this.getResource());
        }
        return this.cacheConfiguration;
    }

    public void destroy() throws Exception {
        if (this.cacheManagerImplicitlyCreated && this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    public void init() throws ShiroException {
        try {
            this.ensureCacheManager();
        }
        catch (MalformedURLException e) {
            throw new ShiroException((Throwable)e);
        }
    }
}

