/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import javax.net.ssl.SSLContext;
import javax.servlet.FilterConfig;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.DefaultHttpClientFactory;
import org.apache.knox.gateway.dispatch.HadoopAuthCookieStore;
import org.apache.knox.gateway.dispatch.HttpAsyncClientFactory;
import org.apache.knox.gateway.dispatch.KnoxSpnegoAuthSchemeFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.metrics.MetricsService;

public class DefaultHttpAsyncClientFactory
extends DefaultHttpClientFactory
implements HttpAsyncClientFactory {
    @Override
    public HttpAsyncClient createAsyncHttpClient(FilterConfig filterConfig) {
        HttpAsyncClientBuilder builder;
        String serviceRole = filterConfig.getInitParameter("serviceRole");
        GatewayConfig gatewayConfig = (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
        GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        if (gatewayConfig != null && gatewayConfig.isMetricsEnabled()) {
            MetricsService metricsService = (MetricsService)services.getService(ServiceType.METRICS_SERVICE);
            builder = metricsService.getInstrumented(HttpAsyncClientBuilder.class);
        } else {
            builder = HttpAsyncClients.custom();
        }
        SSLContext sslContext = this.createSSLContext(services, filterConfig, serviceRole);
        if (sslContext != null) {
            builder.setSSLContext(sslContext);
        }
        if (Boolean.parseBoolean(System.getProperty("gateway.hadoop.kerberos.secured"))) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new DefaultHttpClientFactory.UseJaasCredentials());
            Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new KnoxSpnegoAuthSchemeFactory(true)).build();
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCookieStore((CookieStore)new HadoopAuthCookieStore(gatewayConfig)).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        } else {
            builder.setDefaultCookieStore((CookieStore)new DefaultHttpClientFactory.NoCookieStore());
        }
        builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);
        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE);
        builder.setRedirectStrategy((RedirectStrategy)new DefaultHttpClientFactory.NeverRedirectStrategy());
        int maxConnections = this.getMaxConnections(filterConfig);
        builder.setMaxConnTotal(maxConnections);
        builder.setMaxConnPerRoute(maxConnections);
        builder.setDefaultRequestConfig(DefaultHttpAsyncClientFactory.getRequestConfig(filterConfig, serviceRole));
        return builder.build();
    }
}

