/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Contains common arguments for commands which require SSH'ing into one or more hosts.")
public class BaseApiSshCmdArguments {
    @SerializedName(value="sshPort")
    private BigDecimal sshPort = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="privateKey")
    private String privateKey = null;
    @SerializedName(value="passphrase")
    private String passphrase = null;

    public BaseApiSshCmdArguments sshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
        return this;
    }

    @Schema(example="22", description="SSH port. If unset, defaults to 22.")
    public BigDecimal getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
    }

    public BaseApiSshCmdArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public BaseApiSshCmdArguments password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BaseApiSshCmdArguments privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Schema(description="The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public BaseApiSshCmdArguments passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @Schema(description="The passphrase associated with the private key used to authenticate with the hosts (optional).")
    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseApiSshCmdArguments baseApiSshCmdArguments = (BaseApiSshCmdArguments)o;
        return Objects.equals(this.sshPort, baseApiSshCmdArguments.sshPort) && Objects.equals(this.userName, baseApiSshCmdArguments.userName) && Objects.equals(this.password, baseApiSshCmdArguments.password) && Objects.equals(this.privateKey, baseApiSshCmdArguments.privateKey) && Objects.equals(this.passphrase, baseApiSshCmdArguments.passphrase);
    }

    public int hashCode() {
        return Objects.hash(this.sshPort, this.userName, this.password, this.privateKey, this.passphrase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseApiSshCmdArguments {\n");
        sb.append("    sshPort: ").append(this.toIndentedString(this.sshPort)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    passphrase: ").append(this.toIndentedString(this.passphrase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

