/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.HashMap;
import java.util.Map;

public class SetCookieHeader {
    private final String name;
    private final String value;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String path;
    private String domain;
    private int maxAge = -1;
    private boolean httpOnly;
    private boolean secure;
    private String sameSite;

    public SetCookieHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setSameSite(String sameSite) {
        this.sameSite = sameSite;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append('=').append(this.value);
        if (this.path != null) {
            sb.append("; Path=").append(this.path);
        }
        if (this.domain != null) {
            sb.append("; Domain=").append(this.domain);
        }
        if (this.maxAge != -1) {
            sb.append("; Max-Age=").append(this.maxAge);
        }
        if (this.httpOnly) {
            sb.append("; HttpOnly");
        }
        if (this.secure) {
            sb.append("; Secure");
        }
        if (this.sameSite != null) {
            sb.append("; SameSite=").append(this.sameSite);
        }
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sb.append("; ").append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.toString();
    }
}

