/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiRoleConfig;
import com.cloudera.api.swagger.model.ApiRoleConfigList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollector;
import org.apache.knox.gateway.topology.discovery.cm.TypeNameFilter;

public class ServiceRoleCollectorByService
implements ServiceRoleCollector {
    private static final String VIEW_FULL = "full";
    private final RolesResourceApi rolesResourceApi;
    private final long limit;
    private final TypeNameFilter roleFilter;
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);

    public ServiceRoleCollectorByService(RolesResourceApi rolesResourceApi, long roleConfigPageSize, TypeNameFilter roleFilter) {
        this.rolesResourceApi = rolesResourceApi;
        this.limit = roleConfigPageSize;
        this.roleFilter = roleFilter;
    }

    @Override
    public ApiRoleConfigList getAllServiceRoleConfigurations(String clusterName, String serviceName) throws ApiException {
        ApiRoleConfigList roleConfigList;
        long offset = 0L;
        ApiRoleConfigList allServiceRoleConfigs = new ApiRoleConfigList();
        allServiceRoleConfigs.setItems(new ArrayList());
        do {
            log.fetchingServiceRoleConfigs(serviceName, clusterName, offset, this.limit);
            roleConfigList = this.rolesResourceApi.readRolesConfig(clusterName, serviceName, BigDecimal.valueOf(this.limit), BigDecimal.valueOf(offset), VIEW_FULL);
            if (roleConfigList != null && roleConfigList.getItems() != null) {
                allServiceRoleConfigs.getItems().addAll(roleConfigList.getItems());
            } else {
                log.receivedNullServiceRoleConfigs(serviceName, clusterName);
            }
            offset += this.limit;
        } while (this.configItemSizeMatchesLimit(roleConfigList, this.limit));
        return this.filterIncluded(allServiceRoleConfigs);
    }

    private ApiRoleConfigList filterIncluded(ApiRoleConfigList roleConfigs) {
        List filteredItems = roleConfigs.getItems().stream().filter(this::isIncluded).collect(Collectors.toList());
        return new ApiRoleConfigList().items(filteredItems);
    }

    private boolean configItemSizeMatchesLimit(ApiRoleConfigList roleConfigList, long limit) {
        return roleConfigList != null && roleConfigList.getItems() != null && (long)roleConfigList.getItems().size() == limit;
    }

    public boolean isIncluded(ApiRoleConfig apiRoleConfig) {
        boolean isExcluded = this.roleFilter.isExcluded(apiRoleConfig.getRoleType());
        if (isExcluded) {
            log.skipRoleDiscovery(apiRoleConfig.getName(), apiRoleConfig.getRoleType());
        }
        return !isExcluded;
    }
}

