/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer;

import java.util.List;
import java.util.Optional;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;

public class CsrfAuthorizer
implements Authorizer<UserProfile> {
    private String parameterName = "pac4jCsrfToken";
    private String headerName = "pac4jCsrfToken";
    private boolean checkAllRequests = false;

    public CsrfAuthorizer() {
    }

    public CsrfAuthorizer(String parameterName, String headerName) {
        this.parameterName = parameterName;
        this.headerName = headerName;
    }

    public CsrfAuthorizer(String parameterName, String headerName, boolean checkAllRequests) {
        this(parameterName, headerName);
        this.checkAllRequests = checkAllRequests;
    }

    @Override
    public boolean isAuthorized(WebContext context, List<UserProfile> profiles) {
        boolean checkRequest;
        boolean bl = checkRequest = this.checkAllRequests || ContextHelper.isPost(context) || ContextHelper.isPut(context) || ContextHelper.isPatch(context) || ContextHelper.isDelete(context);
        if (checkRequest) {
            String parameterToken = context.getRequestParameter(this.parameterName).orElse(null);
            String headerToken = context.getRequestHeader(this.headerName).orElse(null);
            Optional<Object> sessionToken = context.getSessionStore().get(context, "pac4jCsrfToken");
            return sessionToken.isPresent() && (((String)sessionToken.get()).equals(parameterToken) || ((String)sessionToken.get()).equals(headerToken));
        }
        return true;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isCheckAllRequests() {
        return this.checkAllRequests;
    }

    public void setCheckAllRequests(boolean checkAllRequests) {
        this.checkAllRequests = checkAllRequests;
    }
}

