/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.imap.message.Literal;

public class BytesBackedLiteral
implements Literal {
    private final byte[] content;

    public static BytesBackedLiteral copy(InputStream stream) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        stream.transferTo((OutputStream)out);
        return BytesBackedLiteral.of(out.toByteArray());
    }

    public static BytesBackedLiteral copy(InputStream stream, int size) throws IOException {
        byte[] buffer = IOUtils.toByteArray((InputStream)stream, (int)size);
        if (stream.read() != -1) {
            throw new IOException("Got a stream of the wrong size...");
        }
        return BytesBackedLiteral.of(buffer);
    }

    public static BytesBackedLiteral of(byte[] bytes) {
        return new BytesBackedLiteral(bytes);
    }

    private BytesBackedLiteral(byte[] content) {
        this.content = content;
    }

    @Override
    public long size() {
        return this.content.length;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }
}

