/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.draft.methods.ErrorResponse;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.GetFilterRequest;
import org.apache.james.jmap.draft.model.GetFilterResponse;
import org.apache.james.jmap.draft.model.MethodCallId;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class GetFilterMethod
implements Method {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFilterMethod.class);
    private static final Method.Request.Name METHOD_NAME = Method.Request.name("getFilter");
    private static final Method.Response.Name RESPONSE_NAME = Method.Response.name("filter");
    private final MetricFactory metricFactory;
    private final FilteringManagement filteringManagement;

    @Inject
    private GetFilterMethod(MetricFactory metricFactory, FilteringManagement filteringManagement) {
        this.metricFactory = metricFactory;
        this.filteringManagement = filteringManagement;
    }

    @Override
    public Method.Request.Name requestHandled() {
        return METHOD_NAME;
    }

    @Override
    public Class<? extends JmapRequest> requestType() {
        return GetFilterRequest.class;
    }

    @Override
    public Flux<JmapResponse> process(JmapRequest request, MethodCallId methodCallId, MailboxSession mailboxSession) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)methodCallId);
        Preconditions.checkNotNull((Object)mailboxSession);
        Preconditions.checkArgument((boolean)(request instanceof GetFilterRequest));
        GetFilterRequest filterRequest = (GetFilterRequest)request;
        return Flux.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-" + METHOD_NAME.getName(), (Publisher)this.process(methodCallId, mailboxSession, filterRequest).contextWrite((ContextView)ReactorUtils.context((String)"GET_FILTER", (MDCBuilder)MDCBuilder.ofValue((String)"action", (String)"GET_FILTER")))));
    }

    private Mono<JmapResponse> process(MethodCallId methodCallId, MailboxSession mailboxSession, GetFilterRequest request) {
        return this.retrieveFilter(methodCallId, mailboxSession.getUser()).onErrorResume(e -> {
            LOGGER.warn("Failed to retrieve filter", e);
            return Mono.just((Object)this.unKnownError(methodCallId));
        });
    }

    private Mono<JmapResponse> retrieveFilter(MethodCallId methodCallId, Username username) {
        return Mono.from((Publisher)this.filteringManagement.listRulesForUser(username)).map(rules -> GetFilterResponse.builder().rules(rules.getRules()).build()).map(getFilterResponse -> JmapResponse.builder().methodCallId(methodCallId).response((Method.Response)getFilterResponse).responseName(RESPONSE_NAME).build());
    }

    private JmapResponse unKnownError(MethodCallId methodCallId) {
        return JmapResponse.builder().methodCallId(methodCallId).responseName(RESPONSE_NAME).response(ErrorResponse.builder().type(SetError.Type.ERROR.asString()).description("Failed to retrieve filter").build()).build();
    }
}

