/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.SeqnoList;

public class RingBufferSeqnoLockless<T>
implements Iterable<T> {
    protected final AtomicReferenceArray<T> buf;
    protected volatile long low;
    protected volatile long hd;
    protected final AtomicLong hr = new AtomicLong(0L);
    protected final long offset;
    protected final Lock lock = new ReentrantLock();
    protected final Condition buffer_full = this.lock.newCondition();
    protected volatile boolean running = true;
    protected final AtomicBoolean processing = new AtomicBoolean(false);

    public RingBufferSeqnoLockless(int capacity, long offset) {
        int cap;
        if (capacity < 1) {
            throw new IllegalArgumentException("incorrect capacity of " + capacity);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("invalid offset of " + offset);
        }
        for (cap = 1; capacity > cap; cap <<= 1) {
        }
        this.buf = new AtomicReferenceArray(cap);
        this.hd = this.offset = offset;
        this.low = this.offset;
        this.hr.set(offset);
    }

    public long getLow() {
        return this.low;
    }

    public long getHighestDelivered() {
        return this.hd;
    }

    public void setHighestDelivered(long hd) {
        this.hd = hd;
    }

    public long getHighestReceived() {
        return this.hr.get();
    }

    public long[] getDigest() {
        return new long[]{this.hd, this.hr.get()};
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public boolean add(long seqno, T element) {
        return this.add(seqno, element, false);
    }

    public boolean add(long seqno, T element, boolean block) {
        long current_hr;
        long new_hr;
        RingBufferSeqnoLockless.validate(seqno);
        if (seqno <= this.hd) {
            return false;
        }
        if (!(seqno - this.low <= (long)this.capacity() || block && this.block(seqno))) {
            return false;
        }
        int index = this.index(seqno);
        if (this.buf.get(index) != null || seqno <= this.hd) {
            return false;
        }
        if (!this.buf.compareAndSet(index, null, element)) {
            return false;
        }
        while ((new_hr = Math.max(seqno, current_hr = this.hr.get())) > current_hr && !this.hr.compareAndSet(current_hr, new_hr)) {
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(boolean nullify) {
        long tmp = this.hd + 1L;
        if (tmp > this.hr.get()) {
            return null;
        }
        int index = this.index(tmp);
        T element = this.buf.get(index);
        if (element == null) {
            return null;
        }
        this.hd = tmp;
        if (nullify) {
            long tmp_low = this.low;
            if (tmp == tmp_low + 1L) {
                this.buf.compareAndSet(index, element, null);
            } else {
                int from = this.index(tmp_low + 1L);
                int length = (int)(tmp - tmp_low);
                int capacity = this.capacity();
                for (int i = from; i < from + length; ++i) {
                    index = i & capacity - 1;
                    this.buf.set(index, null);
                }
            }
            this.low = tmp;
            this.lock.lock();
            try {
                this.buffer_full.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        return element;
    }

    public T remove() {
        return this.remove(false);
    }

    public List<T> removeMany(boolean nullify, int max_results) {
        return this.removeMany(null, nullify, max_results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> removeMany(AtomicBoolean processing, boolean nullify, int max_results) {
        T element;
        long original_hd;
        ArrayList<T> list = null;
        int num_results = 0;
        long start = original_hd = this.hd;
        long end = this.hr.get();
        while (start + 1L <= end && (element = this.buf.get(this.index(start + 1L))) != null) {
            if (list == null) {
                list = new ArrayList<T>(max_results > 0 ? max_results : 20);
            }
            list.add(element);
            ++start;
            if (max_results <= 0 || ++num_results < max_results) continue;
        }
        if (start > original_hd) {
            this.hd = start;
            if (nullify) {
                long tmp_low = this.low;
                int from = this.index(tmp_low + 1L);
                int length = (int)(start - tmp_low);
                int capacity = this.capacity();
                for (int i = from; i < from + length; ++i) {
                    int index = i & capacity - 1;
                    this.buf.set(index, null);
                }
                if (start > this.low) {
                    this.low = start;
                    this.lock.lock();
                    try {
                        this.buffer_full.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
        if ((list == null || list.isEmpty()) && processing != null) {
            processing.set(false);
        }
        return list;
    }

    public T get(long seqno) {
        RingBufferSeqnoLockless.validate(seqno);
        if (seqno <= this.low || seqno > this.hr.get()) {
            return null;
        }
        int index = this.index(seqno);
        return this.buf.get(index);
    }

    public T _get(long seqno) {
        int index = this.index(seqno);
        return index < 0 ? null : (T)this.buf.get(index);
    }

    public List<T> get(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("from (" + from + ") has to be <= to (" + to + ")");
        }
        RingBufferSeqnoLockless.validate(from);
        ArrayList<T> retval = null;
        for (long i = from; i <= to; ++i) {
            T element = this.get(i);
            if (element == null) continue;
            if (retval == null) {
                retval = new ArrayList<T>();
            }
            retval.add(element);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stable(long seqno) {
        RingBufferSeqnoLockless.validate(seqno);
        if (seqno <= this.low) {
            return;
        }
        if (seqno > this.hd) {
            throw new IllegalArgumentException("seqno " + seqno + " cannot be bigger than hd (" + this.hd + ")");
        }
        int from = this.index(this.low + 1L);
        int length = (int)(seqno - this.low);
        int capacity = this.capacity();
        for (int i = from; i < from + length; ++i) {
            int index = i & capacity - 1;
            this.buf.set(index, null);
        }
        if (seqno > this.low) {
            this.low = seqno;
            this.lock.lock();
            try {
                this.buffer_full.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.lock();
        try {
            this.running = false;
            this.buffer_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public final int capacity() {
        return this.buf.length();
    }

    public int size() {
        return this.count(false);
    }

    public int missing() {
        return this.count(true);
    }

    public int spaceUsed() {
        return (int)(this.hr.get() - this.low);
    }

    public double saturation() {
        int space = this.spaceUsed();
        return space == 0 ? 0.0 : (double)space / (double)this.capacity();
    }

    public SeqnoList getMissing() {
        SeqnoList missing = null;
        long tmp_hd = this.hd;
        long tmp_hr = this.hr.get();
        for (long i = tmp_hd + 1L; i <= tmp_hr; ++i) {
            long end;
            if (this.buf.get(this.index(i)) != null) continue;
            if (missing == null) {
                missing = new SeqnoList((int)(tmp_hr - tmp_hd), this.hd);
            }
            for (end = i; this.buf.get(this.index(end + 1L)) == null && end <= tmp_hr; ++end) {
            }
            if (end == i) {
                missing.add(i);
                continue;
            }
            missing.add(i, end);
            i = end;
        }
        return missing;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator(this.buf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.low + " | " + this.hd + " | " + this.hr + "] (" + this.size() + " elements, " + this.missing() + " missing)");
        return sb.toString();
    }

    protected static final void validate(long seqno) {
        if (seqno < 0L) {
            throw new IllegalArgumentException("seqno " + seqno + " cannot be negative");
        }
    }

    protected int index(long seqno) {
        return (int)(seqno - this.offset - 1L & (long)(this.capacity() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean block(long seqno) {
        this.lock.lock();
        try {
            while (this.running && seqno - this.low > (long)this.capacity()) {
                try {
                    this.buffer_full.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int count(boolean missing) {
        int retval = 0;
        long tmp_hd = this.hd;
        long tmp_hr = this.hr.get();
        for (long i = tmp_hd + 1L; i <= tmp_hr; ++i) {
            int index = this.index(i);
            T element = this.buf.get(index);
            if (missing && element == null) {
                ++retval;
            }
            if (missing || element == null) continue;
            ++retval;
        }
        return retval;
    }

    protected class RingBufferIterator
    implements Iterator<T> {
        protected final AtomicReferenceArray<T> buffer;
        protected long current;

        public RingBufferIterator(AtomicReferenceArray<T> buffer) {
            this.current = RingBufferSeqnoLockless.this.hd + 1L;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.current <= RingBufferSeqnoLockless.this.hr.get();
        }

        @Override
        public T next() {
            if (this.current <= RingBufferSeqnoLockless.this.hd) {
                this.current = RingBufferSeqnoLockless.this.hd + 1L;
            }
            return this.buffer.get(RingBufferSeqnoLockless.this.index(this.current++));
        }

        @Override
        public void remove() {
        }
    }
}

