/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;

public class KeywordsCombiner
implements BinaryOperator<Keywords> {
    private static final ImmutableList<Keyword> KEYWORD_TO_INTERSECT = ImmutableList.of((Object)Keyword.DRAFT);
    private static final ImmutableList<Keyword> KEYWORD_NOT_TO_UNION = KEYWORD_TO_INTERSECT;
    private Keywords.KeywordsFactory keywordsFactory = Keywords.lenientFactory();

    @Override
    public Keywords apply(Keywords keywords, Keywords keywords2) {
        return this.keywordsFactory.fromSet((Set<Keyword>)Sets.union(this.union((Set<Keyword>)keywords.getKeywords(), (Set<Keyword>)keywords2.getKeywords(), (List<Keyword>)KEYWORD_NOT_TO_UNION), this.intersect((Set<Keyword>)keywords.getKeywords(), (Set<Keyword>)keywords2.getKeywords(), (List<Keyword>)KEYWORD_TO_INTERSECT)));
    }

    public Set<Keyword> union(Set<Keyword> set1, Set<Keyword> set2, List<Keyword> exceptKeywords) {
        return (Set)Sets.union(set1, set2).stream().filter(keyword -> !exceptKeywords.contains(keyword)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<Keyword> intersect(Set<Keyword> set1, Set<Keyword> set2, List<Keyword> forKeywords) {
        return (Set)Sets.intersection(set1, set2).stream().filter(forKeywords::contains).collect(ImmutableSet.toImmutableSet());
    }
}

