/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.storage.MultiReferenceStorage;
import org.apache.james.mime4j.storage.Storage;
import org.junit.Assert;
import org.junit.Test;

public class MultiReferenceStorageTest {
    @Test
    public void testForwardsGetInputStream() throws Exception {
        DummyStorage storage = new DummyStorage();
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage((Storage)storage);
        Assert.assertEquals(ByteArrayInputStream.class, multiReferenceStorage.getInputStream().getClass());
    }

    @Test
    public void testSingleReference() throws Exception {
        DummyStorage storage = new DummyStorage();
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage((Storage)storage);
        Assert.assertFalse((boolean)storage.deleted);
        multiReferenceStorage.delete();
        Assert.assertTrue((boolean)storage.deleted);
    }

    @Test
    public void testMultiReference() throws Exception {
        DummyStorage storage = new DummyStorage();
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage((Storage)storage);
        multiReferenceStorage.addReference();
        multiReferenceStorage.delete();
        Assert.assertFalse((boolean)storage.deleted);
        multiReferenceStorage.delete();
        Assert.assertTrue((boolean)storage.deleted);
    }

    @Test
    public void testGetInputStreamOnDeleted() throws Exception {
        DummyStorage storage = new DummyStorage();
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage((Storage)storage);
        multiReferenceStorage.delete();
        try {
            multiReferenceStorage.getInputStream();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAddReferenceOnDeleted() throws Exception {
        DummyStorage storage = new DummyStorage();
        MultiReferenceStorage multiReferenceStorage = new MultiReferenceStorage((Storage)storage);
        multiReferenceStorage.delete();
        try {
            multiReferenceStorage.addReference();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static final class DummyStorage
    implements Storage {
        public boolean deleted = false;

        private DummyStorage() {
        }

        public InputStream getInputStream() throws IOException {
            if (this.deleted) {
                throw new IllegalStateException("deleted");
            }
            return new ByteArrayInputStream("dummy".getBytes());
        }

        public void delete() {
            this.deleted = true;
        }
    }
}

