/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xliff;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.xliff.XLIFF12Parser;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XLZParser
extends AbstractParser {
    private static final long serialVersionUID = -1877314028666058564L;
    private static final MediaType XLZ_CONTENT_TYPE = MediaType.application("x-xliff+zip");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(XLZ_CONTENT_TYPE);
    private static final String XLF = ".xlf";
    private Parser xliffParser = new XLIFF12Parser();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipFile zipFile = null;
        ZipInputStream zipStream = null;
        if (stream instanceof TikaInputStream) {
            TikaInputStream tis = (TikaInputStream)stream;
            Object container = ((TikaInputStream)stream).getOpenContainer();
            if (container instanceof ZipFile) {
                zipFile = (ZipFile)container;
            } else if (tis.hasFile()) {
                zipFile = new ZipFile(tis.getFile());
            } else {
                zipStream = new ZipInputStream(stream);
            }
        } else {
            zipStream = new ZipInputStream(stream);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(baseHandler, metadata);
        EndDocumentShieldingContentHandler handler = new EndDocumentShieldingContentHandler(xhtml);
        if (zipFile != null) {
            try {
                this.handleZipFile(zipFile, metadata, context, handler);
            }
            finally {
                zipFile.close();
            }
        }
        try {
            this.handleZipStream(zipStream, metadata, context, handler);
        }
        finally {
            zipStream.close();
        }
        if (handler.isEndDocumentWasCalled()) {
            handler.reallyEndDocument();
        }
    }

    private void handleZipStream(ZipInputStream zipStream, Metadata metadata, ParseContext context, EndDocumentShieldingContentHandler handler) throws IOException, TikaException, SAXException {
        ZipEntry entry = zipStream.getNextEntry();
        if (entry == null) {
            throw new IOException("No entries found in ZipInputStream");
        }
        while (entry != null) {
            if (entry.getName().contains(XLF)) {
                this.xliffParser.parse(zipStream, handler, metadata, context);
            }
            entry = zipStream.getNextEntry();
        }
    }

    private void handleZipFile(ZipFile zipFile, Metadata metadata, ParseContext context, EndDocumentShieldingContentHandler handler) throws IOException, TikaException, SAXException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().contains(XLF)) continue;
            this.xliffParser.parse(zipFile.getInputStream(entry), handler, metadata, context);
        }
    }
}

