/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.info.AbstractLs;
import org.apache.jackrabbit.standalone.cli.info.PrintHelper;

public abstract class AbstractLsNodes
extends AbstractLs {
    private static final ResourceBundle bundle = CommandHelper.getBundle();
    private String pathKey = "path";
    private String uuidKey = "uuid";
    private String mixinKey = "mixin";
    private String nodesSizeKey = "nodeSize";
    private String propertiesSizeKey = "propertiesSize";
    private String referencesSizeKey = "referencesSize";
    private String versionableKey = "versionable";
    private String lockableKey = "lockable";
    private String referenceableKey = "referenceable";
    private String lockedKey = "locked";
    private String hasLockKey = "hasLock";
    private String newKey = "new";
    private String modifiedKey = "modified";
    private String lockTokenKey = "lockToken";
    private int uuidWidth = 36;
    private int nameWidth = 30;
    private int nodeTypeWidth = 20;
    private int pathWidth = 40;
    private int mixinWidth = 30;

    @Override
    public final boolean execute(Context ctx) throws Exception {
        OptionHolder oh = new OptionHolder(ctx);
        Iterator iter = this.getNodes(ctx);
        this.writeHeader(ctx, oh);
        int maxItems = this.getMaxItems(ctx);
        for (int index = 0; iter.hasNext() && index < maxItems; ++index) {
            Node n = (Node)iter.next();
            this.writeItem(ctx, n, oh);
        }
        this.printFooter(ctx, iter);
        return false;
    }

    protected abstract Iterator getNodes(Context var1) throws CommandException, RepositoryException;

    void writeItem(Context ctx, Node n, OptionHolder oh) throws RepositoryException, CommandException {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        ArrayList<Object> texts = new ArrayList<Object>();
        widths.add(new Integer(this.nameWidth));
        Object name = n.getName();
        if (n.getIndex() > 1) {
            name = (String)name + "[" + n.getIndex() + "]";
        }
        texts.add(name);
        widths.add(new Integer(this.nodeTypeWidth));
        texts.add(n.getPrimaryNodeType().getName());
        if (oh.isUuid()) {
            widths.add(new Integer(this.uuidWidth));
            if (n.isNodeType("mix:referenceable")) {
                texts.add(n.getUUID());
            } else {
                texts.add("");
            }
        }
        if (oh.isNew()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isNew()));
        }
        if (oh.isModified()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isModified()));
        }
        if (oh.isMixin()) {
            widths.add(new Integer(this.mixinWidth));
            ArrayList<String> mixins = new ArrayList<String>();
            NodeType[] assigned = n.getMixinNodeTypes();
            for (int i = 0; i < assigned.length; ++i) {
                mixins.add(assigned[i].getName());
            }
            NodeType[] nt = n.getPrimaryNodeType().getSupertypes();
            for (int i = 0; i < nt.length; ++i) {
                if (!nt[i].isMixin()) continue;
                mixins.add(nt[i].getName());
            }
            texts.add(mixins);
        }
        if (oh.isNodesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Long.toString(n.getNodes().getSize()));
        }
        if (oh.isPropertiesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Long.toString(n.getProperties().getSize()));
        }
        if (oh.isReferencesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Long.toString(n.getReferences().getSize()));
        }
        if (oh.isVersionable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isNodeType("mix:versionable")));
        }
        if (oh.isLockable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isNodeType("mix:lockable")));
        }
        if (oh.isReferenceable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isNodeType("mix:referenceable")));
        }
        if (oh.isLocked()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.isLocked()));
        }
        if (oh.isHasLock()) {
            widths.add(new Integer(this.longWidth));
            texts.add(Boolean.toString(n.holdsLock()));
        }
        if (oh.isPath()) {
            widths.add(new Integer(this.pathWidth));
            texts.add(n.getPath());
        }
        if (oh.isLockToken()) {
            widths.add(new Integer(this.nameWidth));
            if (n.isLocked()) {
                texts.add(n.getLock().getLockToken());
            } else {
                texts.add("");
            }
        }
        PrintHelper.printRow(ctx, widths, texts);
    }

    void writeHeader(Context ctx, OptionHolder oh) throws CommandException {
        ArrayList<Integer> widths = new ArrayList<Integer>();
        ArrayList<String> texts = new ArrayList<String>();
        widths.add(new Integer(this.nameWidth));
        texts.add(bundle.getString("word.name"));
        widths.add(new Integer(this.nodeTypeWidth));
        texts.add(bundle.getString("word.nodetype"));
        if (oh.isUuid()) {
            widths.add(new Integer(this.uuidWidth));
            texts.add("uuid");
        }
        if (oh.isNew()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.new"));
        }
        if (oh.isModified()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.modified"));
        }
        if (oh.isMixin()) {
            widths.add(new Integer(this.mixinWidth));
            texts.add("mixin");
        }
        if (oh.isNodesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.nodes"));
        }
        if (oh.isPropertiesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.properties"));
        }
        if (oh.isReferencesSize()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.references"));
        }
        if (oh.isVersionable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.versionable"));
        }
        if (oh.isLockable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.lockable"));
        }
        if (oh.isReferenceable()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.referenceable"));
        }
        if (oh.isLocked()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("word.locked"));
        }
        if (oh.isHasLock()) {
            widths.add(new Integer(this.longWidth));
            texts.add(bundle.getString("phrase.haslock"));
        }
        if (oh.isPath()) {
            widths.add(new Integer(this.pathWidth));
            texts.add(bundle.getString("word.path"));
        }
        if (oh.isLockToken()) {
            widths.add(new Integer(this.nameWidth));
            texts.add(bundle.getString("word.locktoken"));
        }
        PrintHelper.printRow(ctx, widths, texts);
        PrintHelper.printSeparatorRow(ctx, widths, '-');
    }

    public String getHasLockKey() {
        return this.hasLockKey;
    }

    public void setHasLockKey(String hasLockKey) {
        this.hasLockKey = hasLockKey;
    }

    public String getLockableKey() {
        return this.lockableKey;
    }

    public void setLockableKey(String lockableKey) {
        this.lockableKey = lockableKey;
    }

    public String getLockedKey() {
        return this.lockedKey;
    }

    public void setLockedKey(String lockedKey) {
        this.lockedKey = lockedKey;
    }

    public String getMixinKey() {
        return this.mixinKey;
    }

    public void setMixinKey(String mixinKey) {
        this.mixinKey = mixinKey;
    }

    public String getModifiedKey() {
        return this.modifiedKey;
    }

    public void setModifiedKey(String modifiedKey) {
        this.modifiedKey = modifiedKey;
    }

    public String getNewKey() {
        return this.newKey;
    }

    public void setNewKey(String newKey) {
        this.newKey = newKey;
    }

    public String getNodesSizeKey() {
        return this.nodesSizeKey;
    }

    public void setNodesSizeKey(String nodesSizeKey) {
        this.nodesSizeKey = nodesSizeKey;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getPropertiesSizeKey() {
        return this.propertiesSizeKey;
    }

    public void setPropertiesSizeKey(String propertiesSizeKey) {
        this.propertiesSizeKey = propertiesSizeKey;
    }

    public String getReferenceableKey() {
        return this.referenceableKey;
    }

    public void setReferenceableKey(String referenceableKey) {
        this.referenceableKey = referenceableKey;
    }

    public String getReferencesSizeKey() {
        return this.referencesSizeKey;
    }

    public void setReferencesSizeKey(String referencesSizeKey) {
        this.referencesSizeKey = referencesSizeKey;
    }

    public String getUuidKey() {
        return this.uuidKey;
    }

    public void setUuidKey(String uuidKey) {
        this.uuidKey = uuidKey;
    }

    public String getVersionableKey() {
        return this.versionableKey;
    }

    public void setVersionableKey(String versionableKey) {
        this.versionableKey = versionableKey;
    }

    public String getLockTokenKey() {
        return this.lockTokenKey;
    }

    public void setLockTokenKey(String lockTokenKey) {
        this.lockTokenKey = lockTokenKey;
    }

    private class OptionHolder {
        private boolean path = false;
        private boolean uuid = false;
        private boolean mixin = false;
        private boolean nodesSize = false;
        private boolean propertiesSize = false;
        private boolean referencesSize = false;
        private boolean versionable = false;
        private boolean lockable = false;
        private boolean referenceable = false;
        private boolean locked = false;
        private boolean hasLock = false;
        private boolean new_ = false;
        private boolean modified = false;
        private boolean lockToken = false;
        private Context ctx;

        private boolean getFlag(String key) {
            boolean flag = false;
            if (this.ctx.containsKey(key)) {
                flag = Boolean.valueOf((String)this.ctx.get(key));
            }
            return flag;
        }

        public OptionHolder(Context ctx) {
            this.ctx = ctx;
            this.path = this.getFlag(AbstractLsNodes.this.pathKey);
            this.uuid = this.getFlag(AbstractLsNodes.this.uuidKey);
            this.mixin = this.getFlag(AbstractLsNodes.this.mixinKey);
            this.nodesSize = this.getFlag(AbstractLsNodes.this.nodesSizeKey);
            this.propertiesSize = this.getFlag(AbstractLsNodes.this.propertiesSizeKey);
            this.referencesSize = this.getFlag(AbstractLsNodes.this.referencesSizeKey);
            this.versionable = this.getFlag(AbstractLsNodes.this.versionableKey);
            this.lockable = this.getFlag(AbstractLsNodes.this.lockableKey);
            this.referenceable = this.getFlag(AbstractLsNodes.this.referenceableKey);
            this.locked = this.getFlag(AbstractLsNodes.this.lockedKey);
            this.hasLock = this.getFlag(AbstractLsNodes.this.hasLockKey);
            this.new_ = this.getFlag(AbstractLsNodes.this.newKey);
            this.modified = this.getFlag(AbstractLsNodes.this.modifiedKey);
            this.lockToken = this.getFlag(AbstractLsNodes.this.lockTokenKey);
        }

        public boolean isHasLock() {
            return this.hasLock;
        }

        public boolean isLockable() {
            return this.lockable;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isMixin() {
            return this.mixin;
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean isNew() {
            return this.new_;
        }

        public boolean isNodesSize() {
            return this.nodesSize;
        }

        public boolean isPropertiesSize() {
            return this.propertiesSize;
        }

        public boolean isReferenceable() {
            return this.referenceable;
        }

        public boolean isReferencesSize() {
            return this.referencesSize;
        }

        public boolean isUuid() {
            return this.uuid;
        }

        public boolean isVersionable() {
            return this.versionable;
        }

        public boolean isPath() {
            return this.path;
        }

        public boolean isLockToken() {
            return this.lockToken;
        }
    }
}

