/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.BLOBInDataStore;
import org.apache.jackrabbit.core.value.BinaryValueImpl;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.value.InternalValueFactory;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.value.BinaryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueFactoryImpl
extends ValueFactoryQImpl {
    private static final Logger log = LoggerFactory.getLogger(ValueFactoryImpl.class);
    private final DataStore store;

    public ValueFactoryImpl(NamePathResolver resolver, DataStore store) {
        super(new InternalValueFactory(store), resolver);
        this.store = store;
    }

    @Override
    public Value createValue(QValue qvalue) {
        if (qvalue instanceof InternalValue && 2 == qvalue.getType()) {
            try {
                return new BinaryValueImpl(((InternalValue)qvalue).getBLOBFileValue().copy());
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), e);
            }
        }
        return super.createValue(qvalue);
    }

    @Override
    public Binary createBinary(InputStream stream) throws RepositoryException {
        try {
            QValue value = this.getQValueFactory().create(stream);
            if (value instanceof InternalValue) {
                BLOBFileValue bLOBFileValue = ((InternalValue)value).getBLOBFileValue();
                return bLOBFileValue;
            }
            BinaryImpl binaryImpl = new BinaryImpl(stream);
            return binaryImpl;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    @Override
    public Value createValue(Binary binary) {
        try {
            if (binary instanceof BLOBInDataStore) {
                BLOBInDataStore blob = (BLOBInDataStore)binary;
                DataIdentifier identifier = blob.getDataIdentifier();
                InternalValue value = blob.usesDataStore(this.store) ? InternalValue.getInternalValue(identifier, this.store, false) : InternalValue.getInternalValue(identifier, this.store, true);
                if (value != null) {
                    return new BinaryValueImpl(value.getBLOBFileValue());
                }
            } else {
                String reference;
                DataRecord record;
                if (binary instanceof BLOBFileValue) {
                    return new BinaryValueImpl(((BLOBFileValue)binary).copy());
                }
                if (binary instanceof ReferenceBinary && (record = this.store.getRecordFromReference(reference = ((ReferenceBinary)binary).getReference())) != null) {
                    return new BinaryValueImpl(BLOBInDataStore.getInstance(this.store, record.getIdentifier()));
                }
            }
            return this.createValue(binary.getStream());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), e);
            return super.createValue(binary);
        }
    }

    @Override
    public Value createValue(InputStream value) {
        try {
            InternalValue qvalue = (InternalValue)this.getQValueFactory().create(value);
            BinaryValueImpl binaryValueImpl = new BinaryValueImpl(qvalue.getBLOBFileValue());
            return binaryValueImpl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(value);
        }
    }

    @Override
    public Value createValue(String value, int type) throws ValueFormatException {
        if (2 == type) {
            try {
                InternalValue qvalue = (InternalValue)this.getQValueFactory().create(value, type);
                return new BinaryValueImpl(qvalue.getBLOBFileValue());
            }
            catch (RepositoryException e) {
                throw new ValueFormatException(e);
            }
        }
        return super.createValue(value, type);
    }
}

