/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.sql.commands;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.ignite.migrationtools.cli.exceptions.ErrorLoadingInputConfigurationHandlers;
import org.apache.ignite.migrationtools.cli.mixins.ClassloaderOption;
import org.apache.ignite.migrationtools.cli.sql.calls.SqlDdlGeneratorCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipelineBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="sql-ddl-generator", description={"Generates a SQL DDL Script from the cache configurations in the input Ignite 2 configuration xml"})
public class SqlDdlGeneratorCmd
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Parameters(paramLabel="input-file", description={"Ignite 2 Configuration XML"})
    private Path inputFile;
    @CommandLine.Option(names={"-o", "--output"}, description={"Print the DDL Script to a file instead of the STDOUT"})
    private Path targetFile;
    @CommandLine.Option(names={"--stop-on-error"}, description={"Panics on error. By default, skips errors and prints the SQL DDL Script only for the successful caches."})
    private boolean stopOnError;
    @CommandLine.Option(names={"--allow-extra-fields"}, description={"Add an extra column to serialize unsupported attributes. The resulting tables will be compatible with the 'migrate-cache's 'PACK_EXTRA' mode. For more information, please checkout the 'allowExtraFields' method in the IgniteAdapter module."})
    private boolean allowExtraFields;
    @CommandLine.Mixin
    private ClassloaderOption classloaderOption;

    @Override
    public Integer call() {
        SqlDdlGeneratorCall call = new SqlDdlGeneratorCall();
        return this.runPipeline((CallExecutionPipelineBuilder)CallExecutionPipeline.builder((Call)call).exceptionHandlers(ErrorLoadingInputConfigurationHandlers.create()).inputProvider(() -> new SqlDdlGeneratorCall.Input(this.inputFile, this.targetFile, this.stopOnError, this.allowExtraFields, this.classloaderOption.clientClassLoader())));
    }
}

