/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.lang;

import java.util.UUID;
import org.apache.ignite3.lang.ErrorGroup;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.TraceableException;
import org.apache.ignite3.lang.util.TraceIdUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteCheckedException
extends Exception
implements TraceableException {
    private static final long serialVersionUID = 0L;
    private final String errorPrefix;
    private final String groupName;
    private final int code;
    private UUID traceId;

    public IgniteCheckedException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteCheckedException(UUID traceId, int code) {
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteCheckedException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteCheckedException(UUID traceId, int code, String message) {
        super(message);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteCheckedException(int code, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId(cause), code, cause);
    }

    public IgniteCheckedException(UUID traceId, int code, @Nullable Throwable cause) {
        super(cause != null ? cause.getLocalizedMessage() : null, cause);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteCheckedException(int code, String message, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId(cause), code, message, cause);
    }

    public IgniteCheckedException(UUID traceId, int code, String message, @Nullable Throwable cause) {
        super(message, cause);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public String groupName() {
        return this.groupName;
    }

    @Override
    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return this.errorPrefix + "-" + this.groupName() + "-" + Short.toUnsignedInt(this.errorCode());
    }

    @Override
    public short groupCode() {
        return ErrorGroups.extractGroupCode(this.code);
    }

    @Override
    public short errorCode() {
        return ErrorGroup.extractErrorCode(this.code);
    }

    @Override
    public UUID traceId() {
        return this.traceId;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + ErrorGroup.errorMessage(this.errorPrefix, this.traceId, this.groupName, this.code, this.getLocalizedMessage());
    }
}

