/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.PartitionGroupId;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class TxMetaSerializer
extends VersionedSerializer<TxMeta> {
    public static final TxMetaSerializer INSTANCE = new TxMetaSerializer();

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(TxMeta meta, IgniteDataOutput out) throws IOException {
        boolean hasAnyZonePartitionIds = TxMetaSerializer.hasAnyZonePartitionIds(meta);
        if (hasAnyZonePartitionIds) assert (TxMetaSerializer.hasNoTablePartitionIds(meta)) : "Both table-based and zone-based partition IDs: " + meta.enlistedPartitions();
        out.writeBoolean(hasAnyZonePartitionIds);
        out.writeVarInt(meta.txState().id());
        out.writeVarInt(meta.enlistedPartitions().size());
        for (EnlistedPartitionGroup enlistedPartitionGroup : meta.enlistedPartitions()) {
            PartitionGroupId partitionGroupId = (PartitionGroupId)enlistedPartitionGroup.groupId();
            out.writeVarInt(partitionGroupId.objectId());
            out.writeVarInt(partitionGroupId.partitionId());
            TxMetaSerializer.writeVarIntSet(enlistedPartitionGroup.tableIds(), out);
        }
        HybridTimestamp.write(meta.commitTimestamp(), out);
    }

    private static boolean hasAnyZonePartitionIds(TxMeta meta) {
        return meta.enlistedPartitions().stream().anyMatch(partition -> partition.groupId() instanceof ZonePartitionId);
    }

    private static boolean hasNoTablePartitionIds(TxMeta meta) {
        return meta.enlistedPartitions().stream().noneMatch(partition -> partition.groupId() instanceof TablePartitionId);
    }

    @Override
    protected TxMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        boolean usesZonePartitionIds = protoVer >= 2 ? in.readBoolean() : false;
        TxState state = TxState.fromId(in.readVarIntAsInt());
        List<EnlistedPartitionGroup> enlistedPartitions = TxMetaSerializer.readEnlistedPartitions(in, protoVer, usesZonePartitionIds);
        HybridTimestamp commitTimestamp = HybridTimestamp.readNullableFrom(in);
        return new TxMeta(state, enlistedPartitions, commitTimestamp);
    }

    private static List<EnlistedPartitionGroup> readEnlistedPartitions(IgniteDataInput in, byte protoVer, boolean usesZonePartitionIds) throws IOException {
        int length = in.readVarIntAsInt();
        ArrayList<EnlistedPartitionGroup> enlistedPartitions = new ArrayList<EnlistedPartitionGroup>(length);
        for (int i = 0; i < length; ++i) {
            int objectId = in.readVarIntAsInt();
            int partitionId = in.readVarIntAsInt();
            Set<Integer> tableIds = protoVer >= 2 ? TxMetaSerializer.readVarIntSet(in) : Set.of(Integer.valueOf(objectId));
            enlistedPartitions.add(new EnlistedPartitionGroup(TxMetaSerializer.replicationGroupId(objectId, partitionId, usesZonePartitionIds), tableIds));
        }
        return enlistedPartitions;
    }

    private static ReplicationGroupId replicationGroupId(int objectId, int partitionId, boolean usesZonePartitionIds) {
        if (usesZonePartitionIds) {
            return new ZonePartitionId(objectId, partitionId);
        }
        return new TablePartitionId(objectId, partitionId);
    }
}

