/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.io.Serializable;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.TxState;
import org.jetbrains.annotations.Nullable;

public class TransactionResult
implements Serializable {
    private static final long serialVersionUID = -4975086804837572978L;
    private final TxState transactionState;
    private final long commitTimestamp;

    public TransactionResult(TxState transactionState, @Nullable HybridTimestamp commitTimestamp) {
        this.transactionState = transactionState;
        this.commitTimestamp = HybridTimestamp.hybridTimestampToLong(commitTimestamp);
    }

    public TxState transactionState() {
        return this.transactionState;
    }

    @Nullable
    public HybridTimestamp commitTimestamp() {
        return HybridTimestamp.nullableHybridTimestamp(this.commitTimestamp);
    }

    public String toString() {
        return S.toString(TransactionResult.class, this);
    }
}

