/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite3.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.util.CollectionUtils;

public class MergeJoinConverterRule
extends AbstractIgniteConverterRule<LogicalJoin> {
    public static final RelOptRule INSTANCE = new MergeJoinConverterRule();

    public MergeJoinConverterRule() {
        super(LogicalJoin.class, "MergeJoinConverter");
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalJoin logicalJoin = (LogicalJoin)call.rel(0);
        JoinInfo joinInfo = Commons.getNonStrictEquiJoinCondition(logicalJoin);
        return !CollectionUtils.nullOrEmpty(joinInfo.pairs()) && joinInfo.isEqui();
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalJoin rel) {
        RelOptCluster cluster = rel.getCluster();
        JoinInfo joinInfo = JoinInfo.of((RelNode)rel.getLeft(), (RelNode)rel.getRight(), (RexNode)rel.getCondition());
        RelTraitSet leftInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)RelCollations.of((ImmutableIntList)joinInfo.leftKeys));
        RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
        RelTraitSet rightInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()).replace((RelTrait)RelCollations.of((ImmutableIntList)joinInfo.rightKeys));
        RelNode left = MergeJoinConverterRule.convert((RelNode)rel.getLeft(), (RelTraitSet)leftInTraits);
        RelNode right = MergeJoinConverterRule.convert((RelNode)rel.getRight(), (RelTraitSet)rightInTraits);
        return new IgniteMergeJoin(cluster, outTraits, left, right, rel.getCondition(), rel.getVariablesSet(), rel.getJoinType());
    }
}

