/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteConsistencyViolationException;

public class IgniteAtomicConsistencyViolationException
extends IgniteConsistencyViolationException {
    private static final long serialVersionUID = 0L;
    private final Map<KeyCacheObject, EntryGetResult> correctedMap;
    private final Map<KeyCacheObject, EntryGetResult> primaryMap;
    private final Consumer<Map<KeyCacheObject, EntryGetResult>> callback;

    public IgniteAtomicConsistencyViolationException(Map<KeyCacheObject, EntryGetResult> correctedMap, Map<KeyCacheObject, EntryGetResult> primaryMap, Consumer<Map<KeyCacheObject, EntryGetResult>> callback) {
        this.correctedMap = Collections.unmodifiableMap(correctedMap);
        this.primaryMap = Collections.unmodifiableMap(primaryMap);
        this.callback = callback;
        assert (correctedMap.keySet().equals(primaryMap.keySet()));
    }

    public Map<KeyCacheObject, EntryGetResult> correctedMap() {
        return this.correctedMap;
    }

    public Map<KeyCacheObject, EntryGetResult> primaryMap() {
        return this.primaryMap;
    }

    public void onRepaired(KeyCacheObject key) {
        this.callback.accept(Collections.singletonMap(key, this.correctedMap.get(key)));
    }

    @Override
    public Set<KeyCacheObject> keys() {
        return this.correctedMap.keySet();
    }
}

