/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.UnsafeChunk;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import sun.nio.ch.FileChannelImpl;

public class MappedFile
implements Closeable,
DirectMemoryRegion {
    public static final int MAP_RW = 1;
    private static final Mapper mapper = MappedFile.pickMapper();
    private final RandomAccessFile file;
    private final long addr;
    private final long size;

    public MappedFile(File name, long size) throws IOException {
        this.file = new RandomAccessFile(name, "rw");
        try {
            if (size == 0L) {
                size = this.file.length();
            } else {
                this.file.setLength(size);
            }
            this.addr = MappedFile.map(this.file, 1, 0L, size);
            this.size = size;
        }
        catch (IOException e) {
            this.file.close();
            throw e;
        }
    }

    public final RandomAccessFile file() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        try {
            mapper.unmap(this.addr, this.size);
        }
        finally {
            this.file.close();
        }
    }

    @Override
    public final long address() {
        return this.addr;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public DirectMemoryRegion slice(long offset) {
        if (offset < 0L || offset >= this.size) {
            throw new IllegalArgumentException("Failed to create a memory region slice [ptr=" + U.hexLong(this.addr) + ", len=" + this.size + ", offset=" + offset + "]");
        }
        return new UnsafeChunk(this.addr + offset, this.size - offset);
    }

    public static long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
        return mapper.map(f, mode, start, size);
    }

    public static void unmap(long addr, long size) {
        mapper.unmap(addr, size);
    }

    private static Mapper pickMapper() {
        int javaVer = IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion());
        if (javaVer >= 19) {
            return new JDK19Mapper();
        }
        if (javaVer >= 14) {
            return new JDK14Mapper();
        }
        return new LegacyMapper();
    }

    private static class JDK19Mapper
    implements Mapper {
        private static final Method map;
        private static final Method unmap;
        private static final Object dispatcher;

        private JDK19Mapper() {
        }

        @Override
        public long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
            try {
                Object fd = U.field(f.getChannel(), "fd");
                if (dispatcher != null) {
                    return (Long)map.invoke(dispatcher, fd, mode, start, size, false);
                }
                return (Long)map.invoke((Object)f.getChannel(), fd, mode, start, size, false);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                throw target instanceof IOException ? (IOException)target : new IOException(target);
            }
        }

        @Override
        public void unmap(long addr, long size) {
            try {
                unmap.invoke(dispatcher, addr, size);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }

        static {
            try {
                Method map0 = U.findNonPublicMethod(FileChannelImpl.class, "map0", FileDescriptor.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
                Method unmap0 = U.findNonPublicMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);
                if (map0 != null && unmap0 != null) {
                    map = map0;
                    unmap = unmap0;
                    dispatcher = null;
                } else {
                    Class<?> fileDispatcherCls = Class.forName("sun.nio.ch.FileDispatcher");
                    dispatcher = U.staticField(FileChannelImpl.class, "nd");
                    map = U.findNonPublicMethod(fileDispatcherCls, "map", FileDescriptor.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
                    unmap = U.findNonPublicMethod(fileDispatcherCls, "unmap", Long.TYPE, Long.TYPE);
                }
            }
            catch (ClassNotFoundException | IgniteCheckedException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class JDK14Mapper
    extends LegacyMapper {
        private static final Method map0 = U.findNonPublicMethod(FileChannelImpl.class, "map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);

        private JDK14Mapper() {
        }

        @Override
        public long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
            try {
                return (Long)map0.invoke((Object)f.getChannel(), mode, start, size, false);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                throw target instanceof IOException ? (IOException)target : new IOException(target);
            }
        }
    }

    private static class LegacyMapper
    implements Mapper {
        private static final Method map0 = U.findNonPublicMethod(FileChannelImpl.class, "map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        private static final Method unmap0 = U.findNonPublicMethod(FileChannelImpl.class, "unmap0", Long.TYPE, Long.TYPE);

        private LegacyMapper() {
        }

        @Override
        public long map(RandomAccessFile f, int mode, long start, long size) throws IOException {
            try {
                return (Long)map0.invoke((Object)f.getChannel(), mode, start, size);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                throw target instanceof IOException ? (IOException)target : new IOException(target);
            }
        }

        @Override
        public void unmap(long addr, long size) {
            try {
                unmap0.invoke(null, addr, size);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }
    }

    private static interface Mapper {
        public long map(RandomAccessFile var1, int var2, long var3, long var5) throws IOException;

        public void unmap(long var1, long var3);
    }
}

