/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.mockito.internal.configuration.plugins.PluginFinder;
import org.mockito.internal.util.collections.Iterables;
import org.mockito.plugins.PluginSwitch;

class PluginInitializer {
    private final PluginSwitch pluginSwitch;
    private final Set<String> alias;

    PluginInitializer(PluginSwitch pluginSwitch, Set<String> alias) {
        this.pluginSwitch = pluginSwitch;
        this.alias = alias;
    }

    public <T> T loadImpl(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + String.valueOf(service), e);
        }
        try {
            String classOrAlias = new PluginFinder(this.pluginSwitch).findPluginClass(Iterables.toIterable(resources));
            if (classOrAlias != null) {
                if (this.alias.contains(classOrAlias)) {
                    classOrAlias = DefaultMockitoPlugins.getDefaultPluginClass(classOrAlias);
                }
                Class<?> pluginClass = loader.loadClass(classOrAlias);
                PluginInitializer.addReads(pluginClass);
                Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return service.cast(plugin);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + String.valueOf(service) + " implementation declared in " + String.valueOf(resources), e);
        }
    }

    public <T> List<T> loadImpls(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + String.valueOf(service), e);
        }
        try {
            List<String> classesOrAliases = new PluginFinder(this.pluginSwitch).findPluginClasses(Iterables.toIterable(resources));
            ArrayList<T> impls = new ArrayList<T>();
            for (String classOrAlias : classesOrAliases) {
                if (this.alias.contains(classOrAlias)) {
                    classOrAlias = DefaultMockitoPlugins.getDefaultPluginClass(classOrAlias);
                }
                Class<?> pluginClass = loader.loadClass(classOrAlias);
                PluginInitializer.addReads(pluginClass);
                Object plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                impls.add(service.cast(plugin));
            }
            return impls;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + String.valueOf(service) + " implementation declared in " + String.valueOf(resources), e);
        }
    }

    private static void addReads(Class<?> pluginClass) {
        try {
            Method getModule = Class.class.getMethod("getModule", new Class[0]);
            Method addReads = getModule.getReturnType().getMethod("addReads", getModule.getReturnType());
            addReads.invoke(getModule.invoke(PluginInitializer.class, new Object[0]), getModule.invoke(pluginClass, new Object[0]));
        }
        catch (NoSuchMethodException getModule) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

