/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.throttling;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.LongAdderMetric;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemoryMetricSource;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.throttling.CheckpointBufferOverflowWatchdog;
import org.apache.ignite.internal.pagememory.persistence.throttling.CheckpointLockStateChecker;
import org.apache.ignite.internal.pagememory.persistence.throttling.ExponentialBackoffThrottlingStrategy;
import org.apache.ignite.internal.pagememory.persistence.throttling.PagesWriteThrottlePolicy;

public class TargetRatioPagesWriteThrottle
implements PagesWriteThrottlePolicy {
    private static final IgniteLogger LOG = Loggers.forClass(TargetRatioPagesWriteThrottle.class);
    private final long logThresholdNanos;
    private final PersistentPageMemory pageMemory;
    private final Supplier<CheckpointProgress> cpProgress;
    private final CheckpointLockStateChecker stateChecker;
    private final ExponentialBackoffThrottlingStrategy inCheckpointProtection = new ExponentialBackoffThrottlingStrategy();
    private final ExponentialBackoffThrottlingStrategy notInCheckpointProtection = new ExponentialBackoffThrottlingStrategy();
    private final CheckpointBufferOverflowWatchdog cpBufferWatchdog;
    private final ConcurrentHashMap<Long, Thread> cpBufThrottledThreads = new ConcurrentHashMap();
    private final LongAdderMetric totalThrottlingTime = new LongAdderMetric("TotalThrottlingTime", "Total throttling threads time in milliseconds. The Ignite throttles threads that generate dirty pages during the ongoing checkpoint.");

    public TargetRatioPagesWriteThrottle(long logThresholdNanos, PersistentPageMemory pageMemory, Supplier<CheckpointProgress> cpProgress, CheckpointLockStateChecker stateChecker, PersistentPageMemoryMetricSource metricSource) {
        this.logThresholdNanos = logThresholdNanos;
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.stateChecker = stateChecker;
        this.cpBufferWatchdog = new CheckpointBufferOverflowWatchdog(pageMemory);
        metricSource.addMetric(this.totalThrottlingTime);
        assert (cpProgress != null) : "cpProgress must be not null if ratio based throttling mode is used";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        ExponentialBackoffThrottlingStrategy exponentialThrottle;
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        boolean shouldThrottle = false;
        if (isPageInCheckpoint) {
            shouldThrottle = this.isCpBufferOverflowThresholdExceeded();
        }
        if (!shouldThrottle) {
            int cpTotalPages;
            CheckpointProgress progress = this.cpProgress.get();
            if (progress == null) {
                return;
            }
            int cpWrittenPages = progress.writtenPages();
            if (cpWrittenPages == (cpTotalPages = progress.currentCheckpointPagesCount())) {
                shouldThrottle = this.pageMemory.shouldThrottle(0.75);
            } else {
                double dirtyRatioThreshold = (double)cpWrittenPages / (double)cpTotalPages;
                dirtyRatioThreshold = (dirtyRatioThreshold * 0.95 + 0.05) * 7.0 / 12.0;
                shouldThrottle = this.pageMemory.shouldThrottle(dirtyRatioThreshold);
            }
        }
        ExponentialBackoffThrottlingStrategy exponentialBackoffThrottlingStrategy = exponentialThrottle = isPageInCheckpoint ? this.inCheckpointProtection : this.notInCheckpointProtection;
        if (shouldThrottle) {
            long throttleParkTimeNs = exponentialThrottle.protectionParkTime();
            Thread curThread = Thread.currentThread();
            if (throttleParkTimeNs > this.logThresholdNanos) {
                LOG.warn("Parking thread=" + curThread.getName() + " for timeout(ms)=" + TimeUnit.NANOSECONDS.toMillis(throttleParkTimeNs), new Object[0]);
            }
            long startTimeNs = System.nanoTime();
            if (isPageInCheckpoint) {
                this.cpBufThrottledThreads.put(curThread.getId(), curThread);
                try {
                    LockSupport.parkNanos(throttleParkTimeNs);
                }
                finally {
                    this.cpBufThrottledThreads.remove(curThread.getId());
                    if (throttleParkTimeNs > this.logThresholdNanos) {
                        LOG.warn("Unparking thread=" + curThread.getName() + " with park timeout(ms)=" + TimeUnit.NANOSECONDS.toMillis(throttleParkTimeNs), new Object[0]);
                    }
                }
            } else {
                LockSupport.parkNanos(throttleParkTimeNs);
            }
            this.totalThrottlingTime.add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs));
        } else {
            boolean backoffWasAlreadyStarted = exponentialThrottle.resetBackoff();
            if (isPageInCheckpoint && backoffWasAlreadyStarted) {
                this.unparkParkedThreads();
            }
        }
    }

    @Override
    public void wakeupThrottledThreads() {
        if (!this.isCpBufferOverflowThresholdExceeded()) {
            this.inCheckpointProtection.resetBackoff();
            this.unparkParkedThreads();
        }
    }

    private void unparkParkedThreads() {
        this.cpBufThrottledThreads.values().forEach(LockSupport::unpark);
    }

    @Override
    public void onBeginCheckpoint() {
    }

    @Override
    public void onFinishCheckpoint() {
        this.inCheckpointProtection.resetBackoff();
        this.notInCheckpointProtection.resetBackoff();
    }

    @Override
    public boolean isCpBufferOverflowThresholdExceeded() {
        return this.cpBufferWatchdog.isInDangerZone();
    }
}

